"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InMemoryStorage = void 0;
class InMemoryStorage {
    constructor() {
        this.data = {};
    }
    getAll() {
        return Object.values(this.data);
    }
    getByUid(uid) {
        var _a;
        return (_a = this.data[uid]) !== null && _a !== void 0 ? _a : null;
    }
    create(entity) {
        const { uid } = entity;
        if (this.data[uid]) {
            throw new Error(`uid ${uid} already exists`);
        }
        this.data[uid] = entity;
    }
    update(entity) {
        const { uid } = entity;
        if (!this.data[uid]) {
            throw new Error(`uid ${uid} doesn't exist`);
        }
        this.data[uid] = entity;
    }
    delete(uid) {
        if (!this.data[uid]) {
            throw new Error(`uid ${uid} doesn't exist`);
        }
        delete this.data[uid];
    }
}
exports.InMemoryStorage = InMemoryStorage;
//# sourceMappingURL=InMemoryStorage.js.map