export interface PaginationBase {
    limit?: number;
}
export interface OffsetPagination extends PaginationBase {
    offset?: number;
}
export declare type Since = Date;
export declare type Until = Date;
export interface LinkPagination extends PaginationBase {
    since?: Since;
    until?: Until;
}
export declare type Pagination = OffsetPagination | LinkPagination;
export declare function isOffsetPagination(pagination: Pagination): pagination is OffsetPagination;
export declare function isLinkPagination(pagination: Pagination): pagination is LinkPagination;
export declare enum SortOrder {
    ASC = "ascending",
    DESC = "descending"
}
export interface Sorting<TField extends string> {
    field: TField;
    order?: SortOrder;
}
export declare type RequiredSorting<TField extends string> = Required<Sorting<TField>>;
export interface PaginationAndSorting<TSortField extends string> {
    pagination?: Pagination;
    sorting?: Sorting<TSortField>;
}
/**
 * @deprecated don't use this type anymore, instead use pagination functions in pagination.ts
 * TODO remove all usage of this and then remove it
 */
export declare type TPagination = OffsetPagination | {
    limit: number;
};
//# sourceMappingURL=paginationTypes.d.ts.map