import { OptionalKeys } from '../Types/types';
import { IEntity, IUpdatable } from './model';
/**
 * Keys that are not possible to update directly
 */
export declare type NotUpdatableKeys = keyof IEntity;
/**
 * Object of values to update on the entity
 *
 * Contains a subset of the entity minus keys that are not updatable (uid, createdAt, archivedAt)
 */
export declare type UpdateEntity<TEntity extends IEntity> = Partial<Omit<TEntity, NotUpdatableKeys>>;
export declare type UnsetKeys<TEntity extends IEntity> = OptionalKeys<TEntity>[];
export interface IModelUpdatable<TEntity extends IEntity> {
    /**
     * Update entity values
     */
    update(uid: TEntity['uid'], update: UpdateEntity<TEntity> & IUpdatable): Promise<void>;
    /**
     * Unset values, that are optional
     */
    unset(uid: TEntity['uid'], updatedAt: Date, unsetKeys: UnsetKeys<TEntity>): Promise<void>;
}
//# sourceMappingURL=IModelUpdatable.d.ts.map