"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMongoFixturesFactory = void 0;
const fixturesFactory_1 = require("./fixturesFactory");
/**
 * Creates a fixtures factory that persists created fixtures in MongoDB
 */
function createMongoFixturesFactory({ mongodbConnection, collection, createEntity, }) {
    const fixturesFactory = (0, fixturesFactory_1.createFixturesFactory)({ createEntity });
    return {
        create(props) {
            return __awaiter(this, void 0, void 0, function* () {
                const entity = fixturesFactory.create(props);
                yield mongodbConnection.connection.collection(collection).insertOne(entity);
                return entity;
            });
        },
        createMany(props) {
            return __awaiter(this, void 0, void 0, function* () {
                const items = fixturesFactory.createMany(props);
                yield mongodbConnection.connection.collection(collection).insertMany(items);
                return items;
            });
        },
    };
}
exports.createMongoFixturesFactory = createMongoFixturesFactory;
//# sourceMappingURL=persistentFixturesFactory.js.map