"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFixturesFactory = void 0;
/**
 * Creates a fixtures factory that simply generates and returns fixtures
 */
function createFixturesFactory({ createEntity, }) {
    return {
        create(props) {
            return createEntity(props);
        },
        createMany(props) {
            const { count } = props;
            const items = [];
            for (let i = 0; i < count; i++) {
                items.push(createEntity(props));
            }
            return items;
        },
    };
}
exports.createFixturesFactory = createFixturesFactory;
//# sourceMappingURL=fixturesFactory.js.map