"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFixturesFactories = void 0;
const fixturesFactory_1 = require("./fixturesFactory");
const persistentFixturesFactory_1 = require("./persistentFixturesFactory");
/**
 * Returns a convenience object that can create any kind of fixtures factory for one type of fixtures
 */
function createFixturesFactories({ mongodbCollection, createEntity, }) {
    return {
        createSimpleFactory() {
            return (0, fixturesFactory_1.createFixturesFactory)({ createEntity });
        },
        createMongoFactory(mongodbConnection) {
            return (0, persistentFixturesFactory_1.createMongoFixturesFactory)({
                mongodbConnection,
                collection: mongodbCollection,
                createEntity,
            });
        },
    };
}
exports.createFixturesFactories = createFixturesFactories;
//# sourceMappingURL=fixturesFactories.js.map