import { IMongodbConnection } from '@signageos/lib/dist/MongoDB/mongoDBConnectionFactory';
/**
 * Returns a convenience object that can create any kind of fixtures factory for one type of fixtures
 */
export declare function createFixturesFactories<TEntity, TCustomFields extends Partial<TEntity> = Partial<TEntity>, TDependencies extends {} = {}>({ mongodbCollection, createEntity, }: {
    mongodbCollection: string;
    createEntity: (props: TDependencies & {
        customFields?: TCustomFields;
    }) => TEntity;
}): {
    createSimpleFactory(): import("./fixturesFactory").IFixturesFactory<TEntity, TCustomFields, TDependencies & {
        customFields?: TCustomFields | undefined;
    }>;
    createMongoFactory(mongodbConnection: IMongodbConnection): import("./persistentFixturesFactory").IPersistentFixturesFactory<TEntity, TCustomFields, TDependencies & {
        customFields?: TCustomFields | undefined;
    }>;
};
//# sourceMappingURL=fixturesFactories.d.ts.map