export declare enum Domain {
    PLATFORM = "platform",
    ACTION_LOG = "actionLog"
}
export declare type IConsistencyOptions = {
    /**
     * It will resolve promise once the command-handler confirm events are persisted, but not wait for any consumer to be processed.
     * This eventual consistency is pessimistic and read databases could not be up to date after event enqueue is resolved.
     * For stronger consistency, please see strong option.
     * @default 'eventual'
     */
    consistency?: 'eventual';
} | {
    /**
     * Strong option is waiting for all events to be fully consumed and responded success.
     * This makes resolve of promise slower but much stronger consistent.
     * This option is recommended only in some cases where consistency in DB is required.
     */
    consistency: 'strong';
    /**
     * You can choose which domain you are waiting for. There are 2 basic domains.
     */
    domain: Domain;
} | {
    /**
     * Uncontrolled option is not waiting for any event to be consumed nor command-handler confirm events to be persisted.
     */
    consistency: 'uncontrolled';
};
//# sourceMappingURL=consistency.d.ts.map