"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareCommandSynchronization = void 0;
const Debug = require("debug");
const observation_1 = require("../../Helpers/observation");
const debug = Debug('@signageos/user-domain-model:Lib:CQRS:commandSynchronization');
/**
 * Based on timestamp, we can wait for all database consumers to be synchronized.
 * So in case the options are set to 'strong' consistency,
 * the response waitSynchronized is resolved only when the database wrote all changes.
 */
function prepareCommandSynchronization(domainModel, consistencyOptions) {
    return __awaiter(this, void 0, void 0, function* () {
        return {
            waitSynchronized(values) {
                return __awaiter(this, void 0, void 0, function* () {
                    if ((consistencyOptions === null || consistencyOptions === void 0 ? void 0 : consistencyOptions.consistency) === 'strong') {
                        debug('wait strong started', values.timestamp);
                        const domainObservable = yield domainModel.observeByName(consistencyOptions.domain);
                        const synchronizedObservable = domainObservable.filter((domain) => isDomainOfProcessedCommandSynchronized(domain, values.timestamp));
                        // TODO reduce to only one mongo query if possible
                        const firstPromise = (0, observation_1.waitForFirst)(synchronizedObservable);
                        const currentDomain = yield domainModel.fetchByName(consistencyOptions.domain);
                        if (!currentDomain || !isDomainOfProcessedCommandSynchronized(currentDomain, values.timestamp)) {
                            yield firstPromise;
                        }
                        else {
                            const silencedPromise = firstPromise.catch(() => undefined); // Silencing the cancel error
                            firstPromise.cancel();
                            yield silencedPromise;
                        }
                        debug('wait strong synchronized', values.timestamp);
                    }
                });
            },
            finalize() {
                return __awaiter(this, void 0, void 0, function* () {
                    // nothing to clear
                });
            },
        };
    });
}
exports.prepareCommandSynchronization = prepareCommandSynchronization;
function isDomainOfProcessedCommandSynchronized(domain, timestamp) {
    return (domain.lastEventReceivedAt.valueOf() > timestamp.receivedAt.valueOf() ||
        (domain.lastEventReceivedAt.valueOf() === timestamp.receivedAt.valueOf() && domain.lastEventSecondaryIndex >= timestamp.secondaryIndex));
}
//# sourceMappingURL=commandSynchronization.js.map