"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCommand = void 0;
const generators_1 = require("@signageos/commands/dist/generators");
const dateTimeFactory_1 = require("@signageos/lib/dist/DateTime/dateTimeFactory");
function createCommand(payload, { sourceUid, context }) {
    return __awaiter(this, void 0, void 0, function* () {
        return {
            id: (0, generators_1.uid)(),
            type: payload.type,
            sourceUid,
            receivedAt: (0, dateTimeFactory_1.now)().toDate(),
            payload: context
                ? Object.assign(Object.assign({}, payload), { context: yield context }) : payload,
        };
    });
}
exports.createCommand = createCommand;
//# sourceMappingURL=commandFactory.js.map