"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCommandDispatcher = exports.CommandProcessError = exports.CommandDispatchUnknownError = exports.CommandDispatchGeneralError = exports.CommandDispatchZodError = exports.CommandDispatchError = exports.Domain = exports.HIGH_PRIORITY = void 0;
const commandQueue_1 = require("@signageos/lib/dist/AMQP/CQRS/commandQueue");
const Debug = require("debug");
const debug = Debug('@signageos/user-domain-model:Lib:CQRS:commandDispatcher');
const zodError_1 = require("@signageos/lib/dist/Zod/zodError");
const zod_1 = require("@signageos/lib/dist/Zod/zod");
const commandSynchronization_1 = require("./commandSynchronization");
exports.HIGH_PRIORITY = { priority: 7 };
/** @deprecated Use `consistency` file exports instead */
var consistency_1 = require("./consistency");
Object.defineProperty(exports, "Domain", { enumerable: true, get: function () { return consistency_1.Domain; } });
class CommandDispatchError extends Error {
}
exports.CommandDispatchError = CommandDispatchError;
class CommandDispatchZodError extends CommandDispatchError {
    constructor(message) {
        super(`CommandDispatchZodError: ${message}`);
        this.name = 'CommandDispatchZodError';
        Object.setPrototypeOf(this, CommandDispatchZodError.prototype);
    }
}
exports.CommandDispatchZodError = CommandDispatchZodError;
class CommandDispatchGeneralError extends CommandDispatchError {
    constructor(message) {
        super(`CommandDispatchGeneralError: ${message}`);
        this.name = 'CommandDispatchGeneralError';
        Object.setPrototypeOf(this, CommandDispatchGeneralError.prototype);
    }
}
exports.CommandDispatchGeneralError = CommandDispatchGeneralError;
class CommandDispatchUnknownError extends CommandDispatchError {
    constructor(message) {
        super(`CommandDispatchUnknownError: ${message}`);
        this.name = 'CommandDispatchUnknownError';
        Object.setPrototypeOf(this, CommandDispatchUnknownError.prototype);
    }
}
exports.CommandDispatchUnknownError = CommandDispatchUnknownError;
class CommandProcessError extends Error {
}
exports.CommandProcessError = CommandProcessError;
const createCommandDispatcher = (amqpConnection, domainModel) => {
    return {
        dispatch(command, messageOptions, consistencyOptions) {
            return __awaiter(this, void 0, void 0, function* () {
                debug('processCommand', command, consistencyOptions);
                if ((consistencyOptions === null || consistencyOptions === void 0 ? void 0 : consistencyOptions.consistency) === 'uncontrolled') {
                    yield (0, commandQueue_1.enqueue)(amqpConnection, command, messageOptions);
                    return null;
                }
                const synchronization = yield (0, commandSynchronization_1.prepareCommandSynchronization)(domainModel, consistencyOptions);
                try {
                    debug('process command', command.type);
                    const result = yield (0, commandQueue_1.process)(amqpConnection, command, messageOptions);
                    if (result.status === 'error') {
                        if ((0, zodError_1.isZodError)(result.error)) {
                            throw new CommandDispatchZodError(`Failed to dispatch command ${command.type}: ${(0, zod_1.formatZodErrorMessage)(result.error)}`);
                        }
                        if (result.error.message) {
                            throw new CommandDispatchGeneralError(`Failed to dispatch command ${command.type}: ${result.error.message}`);
                        }
                        throw new CommandDispatchUnknownError(`Failed to dispatch command ${command.type}: ${result.error}`);
                    }
                    if (result.status === 'process_failed') {
                        throw new CommandProcessError(`Failed to process command ${command.type}: ${result.message}`);
                    }
                    const resultTimestamp = result.timestamp;
                    if (resultTimestamp) {
                        yield synchronization.waitSynchronized({
                            timestamp: resultTimestamp,
                        });
                        debug('processCommand strong synchronized', result.command.id);
                    }
                    const commandResult = {
                        id: result.command.id,
                    };
                    return commandResult;
                }
                finally {
                    yield synchronization.finalize();
                }
            });
        },
    };
};
exports.createCommandDispatcher = createCommandDispatcher;
//# sourceMappingURL=commandDispatcher.js.map