import { IAMQPConnection } from '@signageos/lib/dist/AMQP/amqpConnectionFactory';
import ICommand, { ICommandPayload } from '@signageos/lib/dist/AMQP/CQRS/ICommand';
import IMessageOptions from '@signageos/lib/dist/AMQP/IMessageOptions';
import { IDomainModel } from '../../Schema/EventSourcing/domainModel';
import { IConsistencyOptions } from './consistency';
/**
 * @note sometimes we need some value generated by command-handler
 * @id id generated by command handler
 */
export interface ICommandResult {
    id: string;
}
export declare type DispatchReturnType<TConsistencyOptions extends IConsistencyOptions = IConsistencyOptions> = TConsistencyOptions['consistency'] extends 'uncontrolled' ? null : ICommandResult;
export interface ICommandDispatcher {
    dispatch<TCommandPayload extends ICommandPayload<string>, TConsistencyOptions extends IConsistencyOptions = IConsistencyOptions>(command: ICommand<TCommandPayload>, messageOptions?: IMessageOptions, consistencyOptions?: TConsistencyOptions): Promise<DispatchReturnType<TConsistencyOptions>>;
    /**
     * Dispatch command to CQRS processing
     * @throws CommandProcessError When command cannot be delivered caused be temporary error. E.g.: RabbitMQ down, timeout etc.
     * @throws CommandDispatchError If command is not valid for current state of system. Usually invalid parameters (analogy for REST 400)
     * @param command Full command usually created by createCommand helper
     * @param messageOptions Special options passed to message to AMQP
     * @param consistencyOptions Options to specify whether to wait on successfully consumed events or not
     * @returns Promise of command result if consistency is not `uncontrolled` or `null` otherwise
     */
    dispatch<TCommandPayload extends ICommandPayload<string>, TConsistencyOptions extends IConsistencyOptions>(command: ICommand<TCommandPayload>, messageOptions?: IMessageOptions, consistencyOptions?: TConsistencyOptions): Promise<ICommandResult | null>;
}
export declare const HIGH_PRIORITY: {
    priority: number;
};
/** @deprecated Use `consistency` file exports instead */
export { IConsistencyOptions, Domain } from './consistency';
export declare class CommandDispatchError extends Error {
}
export declare class CommandDispatchZodError extends CommandDispatchError {
    constructor(message: string);
}
export declare class CommandDispatchGeneralError extends CommandDispatchError {
    constructor(message: string);
}
export declare class CommandDispatchUnknownError extends CommandDispatchError {
    constructor(message: string);
}
export declare class CommandProcessError extends Error {
}
export declare const createCommandDispatcher: (amqpConnection: IAMQPConnection, domainModel: IDomainModel) => ICommandDispatcher;
//# sourceMappingURL=commandDispatcher.d.ts.map