"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEqualsMultipleOrExpression = void 0;
/**
 * Generates influx `or` expression
 * @param identifierName
 * @param fieldName
 * @param values
 */
function createEqualsMultipleOrExpression(identifierName, fieldName, values) {
    return values
        .reduce((accumulator, value, idx) => {
        accumulator.push(`${identifierName}["${fieldName}"] == "${value}"${idx < values.length - 1 ? ' or ' : ''}`);
        return accumulator;
    }, [])
        .join('');
}
exports.createEqualsMultipleOrExpression = createEqualsMultipleOrExpression;
//# sourceMappingURL=expressionCreator.js.map