"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMongoFixtureFactories = exports.createSimpleFixtureFactories = void 0;
const object_1 = require("@signageos/lib/dist/Utils/object");
const accountFixtures_1 = require("./Account/accountFixtures");
const accountSettingsFixtures_1 = require("./Account/Settings/accountSettingsFixtures");
const applicationVersionFixtures_1 = require("./Application/Version/applicationVersionFixtures");
const applicationVersionBuildRequestFixtures_1 = require("./Application/Version/applicationVersionBuildRequestFixtures");
const bulkOperationFixtures_1 = require("./BulkOperation/bulkOperationFixtures");
const companyNetworkFixtures_1 = require("./CompanyNetwork/companyNetworkFixtures");
const deviceFixtures_1 = require("./Device/deviceFixtures");
const deviceVerificationFixtures_1 = require("./Device/deviceVerificationFixtures");
const screenshotFixtures_1 = require("./Device/Screenshot/screenshotFixtures");
const deviceActionLogFixtures_1 = require("./Device/ActionLog/deviceActionLogFixtures");
const devicePowerActionFixtures_1 = require("./Device/PowerAction/devicePowerActionFixtures");
const issuedServerLicenseFixtures_1 = require("./License/issuedServerLicenseFixtures");
const issuedServerLicenseValidityFixtures_1 = require("./License/issuedServerLicenseValidityFixtures");
const issuedDeviceLicenseFixtures_1 = require("./License/issuedDeviceLicenseFixtures");
const ownServerLicenseFixtures_1 = require("./License/ownServerLicenseFixtures");
const ownServerLicenseValidityFixtures_1 = require("./License/ownServerLicenseValidityFixtures");
const organizationFixtures_1 = require("./Organization/organizationFixtures");
const policyLogFixtures_1 = require("./PolicyLog/policyLogFixtures");
const termsAndConditionsFixtures_1 = require("./TermsAndConditions/termsAndConditionsFixtures");
const termsAndConditionsVersionFixtures_1 = require("./TermsAndConditionsVersion/termsAndConditionsVersionFixtures");
const uiThemeFixtures_1 = require("./UITheme/uiThemeFixtures");
const whiteLabelSettingsFixtures_1 = require("./WhiteLabelSettings/whiteLabelSettingsFixtures");
const packageFixtures_1 = require("./Package/packageFixtures");
const packageVersionFixtures_1 = require("./Package/packageVersionFixtures");
const bulkRequestedEventFixtures_1 = require("./BulkOperation/bulkRequestedEventFixtures");
const organizationTagFixtures_1 = require("./Organization/organizationTagFixtures");
const policyFixtures_1 = require("./Policy/policyFixtures");
const appletFixtures_1 = require("./Applet/appletFixtures");
const appletVersionFixtures_1 = require("./Applet/appletVersionFixtures");
const timingFixtures_1 = require("./Timing/timingFixtures");
const timingCommandFixtures_1 = require("./Timing/Command/timingCommandFixtures");
const deviceInfoFixtures_1 = require("./Device/DeviceInfo/deviceInfoFixtures");
const locationFixtures_1 = require("./Location/locationFixtures");
const alertFixtures_1 = require("./Alert/alertFixtures");
const alertRuleFixtures_1 = require("./Alert/alertRuleFixtures");
const deviceProvisioningRecipeFixtures_1 = require("./Device/ProvisioningRecipe/deviceProvisioningRecipeFixtures");
const deviceSessionFixtures_1 = require("./Device/Session/deviceSessionFixtures");
const systemLogFixtures_1 = require("./SystemLog/systemLogFixtures");
const thirdPartyCredentialsFactories_1 = require("./ThirdPartyCredentials/thirdPartyCredentialsFactories");
const deviceConfigurationFixtures_1 = require("./Device/Configuration/deviceConfigurationFixtures");
/**
 * Factories for all fixtures factories
 *
 * If you write a new fixture factory, just add it to this map and it will get automatically included
 * in the return types of createSimpleFixtureFactories() and createMongoFixtureFactories()
 */
const fixturesFactories = {
    alert: (0, alertFixtures_1.createAlertFixturesFactories)(),
    alertRule: (0, alertRuleFixtures_1.createAlertRuleFixturesFactories)(),
    account: (0, accountFixtures_1.createAccountFixturesFactories)(),
    accountSettings: (0, accountSettingsFixtures_1.createAccountSettingsFixturesFactories)(),
    applicationVersion: (0, applicationVersionFixtures_1.createApplicationVersionFixturesFactories)(),
    applicationVersionBuildRequest: (0, applicationVersionBuildRequestFixtures_1.createApplicationVersionBuildRequestFixturesFactories)(),
    bulkOperation: (0, bulkOperationFixtures_1.createBulkOperationFixturesFactories)(),
    bulkRequestedEvent: (0, bulkRequestedEventFixtures_1.createBulkRequestedEventFixtureFactories)(),
    companyNetwork: (0, companyNetworkFixtures_1.createCompanyNetworkFixturesFactories)(),
    company: (0, organizationFixtures_1.createCompanyFixturesFactories)(),
    organization: (0, organizationFixtures_1.createOrganizationFixturesFactories)(),
    uiTheme: (0, uiThemeFixtures_1.createUIThemeFixturesFactories)(),
    whiteLabelSettings: (0, whiteLabelSettingsFixtures_1.createWhiteLabelSettingsFixturesFactories)(),
    device: (0, deviceFixtures_1.createDeviceFixturesFactories)(),
    deviceInfo: (0, deviceInfoFixtures_1.createDeviceInfoFixturesFactories)(),
    deviceConfiguration: (0, deviceConfigurationFixtures_1.createDeviceConfigurationFixturesFactories)(),
    deviceVerification: (0, deviceVerificationFixtures_1.createDeviceVerificationFixturesFactories)(),
    deviceScreenshot: (0, screenshotFixtures_1.createScreenshotFixturesFactories)(),
    deviceActionLog: (0, deviceActionLogFixtures_1.createDeviceActionLogFixturesFactories)(),
    devicePowerAction: (0, devicePowerActionFixtures_1.createDevicePowerActionFixturesFactories)(),
    deviceSession: (0, deviceSessionFixtures_1.createDeviceSessionFixturesFactories)(),
    issuedServerLicense: (0, issuedServerLicenseFixtures_1.createIssuedServerLicenseFixturesFactories)(),
    issuedServerLicenseValidity: (0, issuedServerLicenseValidityFixtures_1.createIssuedServerLicenseValidityFixturesFactories)(),
    issuedDeviceLicense: (0, issuedDeviceLicenseFixtures_1.createIssuedDeviceLicenseFixturesFactories)(),
    ownServerLicense: (0, ownServerLicenseFixtures_1.createOwnServerLicenseFixturesFactories)(),
    ownServerLicenseValidity: (0, ownServerLicenseValidityFixtures_1.createOwnServerLicenseValidityFixturesFactories)(),
    termsAndConditions: (0, termsAndConditionsFixtures_1.createTermsAndConditionsFixturesFactories)(),
    termsAndConditionsVersion: (0, termsAndConditionsVersionFixtures_1.createTermsAndConditionsVersionFixturesFactories)(),
    policyLog: (0, policyLogFixtures_1.createPolicyLogFixturesFactories)(),
    policy: (0, policyFixtures_1.createPolicyFixturesFactories)(),
    package: (0, packageFixtures_1.createPackageFixturesFactories)(),
    packageVersion: (0, packageVersionFixtures_1.createPackageVersionFixturesFactories)(),
    organizationTag: (0, organizationTagFixtures_1.createOrganizationTagFixturesFactories)(),
    applet: (0, appletFixtures_1.createAppletFixturesFactories)(),
    appletVersion: (0, appletVersionFixtures_1.createAppletVersionFixturesFactories)(),
    timing: (0, timingFixtures_1.createTimingFixturesFactories)(),
    timingCommand: (0, timingCommandFixtures_1.createTimingCommandFixturesFactories)(),
    location: (0, locationFixtures_1.createLocationFixturesFactories)(),
    deviceProvisioningRecipe: (0, deviceProvisioningRecipeFixtures_1.createDeviceProvisioningRecipeFixturesFactories)(),
    systemLog: (0, systemLogFixtures_1.createSystemLogFixturesFactories)(),
    thirdPartyCredentials: (0, thirdPartyCredentialsFactories_1.createThirdPartyCredentialsFixturesFactories)(),
};
/**
 * Returns a map of all simple fixture factories
 *
 * Simple fixture factories don't use any database and just create fixtures in memory
 */
function createSimpleFixtureFactories() {
    const result = {};
    for (const key of (0, object_1.getObjectKeys)(fixturesFactories)) {
        result[key] = fixturesFactories[key].createSimpleFactory();
    }
    return result;
}
exports.createSimpleFixtureFactories = createSimpleFixtureFactories;
/**
 * Returns a map of all MongoDB fixture factories
 *
 * All fixtures created by these fixture factories are saved to MongoDB database via the provided mongodbConnection
 */
function createMongoFixtureFactories(mongoConnection) {
    const result = {};
    for (const key of (0, object_1.getObjectKeys)(fixturesFactories)) {
        result[key] = fixturesFactories[key].createMongoFactory(mongoConnection);
    }
    return result;
}
exports.createMongoFixtureFactories = createMongoFixtureFactories;
//# sourceMappingURL=fixturesFactories.js.map