import { IMongodbConnection } from '@signageos/lib/dist/MongoDB/mongoDBConnectionFactory';
/**
 * Factories for all fixtures factories
 *
 * If you write a new fixture factory, just add it to this map and it will get automatically included
 * in the return types of createSimpleFixtureFactories() and createMongoFixtureFactories()
 */
declare const fixturesFactories: {
    alert: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Alert/alertModel").IAlert, Partial<Omit<import("../Schema/Alert/alertModel").IAlert, "organizationUid" | "alertRuleUid" | "deviceIdentityHashes">>, import("./Alert/alertFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Alert/alertModel").IAlert, "organizationUid" | "alertRuleUid" | "deviceIdentityHashes">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Alert/alertModel").IAlert, Partial<Omit<import("../Schema/Alert/alertModel").IAlert, "organizationUid" | "alertRuleUid" | "deviceIdentityHashes">>, import("./Alert/alertFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Alert/alertModel").IAlert, "organizationUid" | "alertRuleUid" | "deviceIdentityHashes">> | undefined;
        }>;
    };
    alertRule: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Alert/alertRuleModel").IAlertRule, Partial<Omit<import("../Schema/Alert/alertRuleModel").IAlertRule, "companyUid">>, import("./Alert/alertRuleFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Alert/alertRuleModel").IAlertRule, "companyUid">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Alert/alertRuleModel").IAlertRule, Partial<Omit<import("../Schema/Alert/alertRuleModel").IAlertRule, "companyUid">>, import("./Alert/alertRuleFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Alert/alertRuleModel").IAlertRule, "companyUid">> | undefined;
        }>;
    };
    account: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Account/accountModel").IAccount, Partial<import("../Schema/Account/accountModel").IAccount>, import("./Account/accountFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Account/accountModel").IAccount> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Account/accountModel").IAccount, Partial<import("../Schema/Account/accountModel").IAccount>, import("./Account/accountFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Account/accountModel").IAccount> | undefined;
        }>;
    };
    accountSettings: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Account/accountSettingsModel").IAccountSettings, Partial<import("../Schema/Account/accountSettingsModel").IAccountSettings>, import("./Account/Settings/accountSettingsFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Account/accountSettingsModel").IAccountSettings> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Account/accountSettingsModel").IAccountSettings, Partial<import("../Schema/Account/accountSettingsModel").IAccountSettings>, import("./Account/Settings/accountSettingsFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Account/accountSettingsModel").IAccountSettings> | undefined;
        }>;
    };
    applicationVersion: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Application/Version/applicationVersionModel").IApplicationVersion, Partial<import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionRequired> | Partial<import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionRequired & import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionOptional>, import("./Application/Version/applicationVersionFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionRequired> | Partial<import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionRequired & import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionOptional> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Application/Version/applicationVersionModel").IApplicationVersion, Partial<import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionRequired> | Partial<import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionRequired & import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionOptional>, import("./Application/Version/applicationVersionFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionRequired> | Partial<import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionRequired & import("../Schema/Application/Version/applicationVersionModel").IApplicationVersionOptional> | undefined;
        }>;
    };
    applicationVersionBuildRequest: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Application/Version/applicationVersionBuildRequestModel").IApplicationVersionBuildRequest, Partial<import("../Schema/Application/Version/applicationVersionBuildRequestModel").IApplicationVersionBuildRequest>, import("./Application/Version/applicationVersionBuildRequestFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Application/Version/applicationVersionBuildRequestModel").IApplicationVersionBuildRequest> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Application/Version/applicationVersionBuildRequestModel").IApplicationVersionBuildRequest, Partial<import("../Schema/Application/Version/applicationVersionBuildRequestModel").IApplicationVersionBuildRequest>, import("./Application/Version/applicationVersionBuildRequestFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Application/Version/applicationVersionBuildRequestModel").IApplicationVersionBuildRequest> | undefined;
        }>;
    };
    bulkOperation: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/BulkOperation/bulkOperationModel").IBulkOperation<{
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            version: string;
        } | {
            volume: number;
        } | {
            brightness1: number;
            brightness2: number;
            timeFrom1: string;
            timeFrom2: string;
        } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
            timestamp: number;
            timezone: string | null;
            ntpServer?: string | undefined;
        } | {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        } | {
            version: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            buildHash: string;
            version: string;
            build: string | null;
        } | {
            packageUri: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            specs: object;
        } | {
            powerType: string;
        } | {
            powerType: string;
            weekdays: string[];
            time: string;
        } | {
            scheduledPowerActionUid: string;
        } | {
            enabled: boolean;
        } | {
            resolution: {
                height: number;
                width: number;
                framerate?: number | undefined;
            };
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        } | {
            verificationHash: string;
        } | {
            verificationHash: string;
        } | {
            name: string;
        } | {
            subscriptionType: string | null;
        } | {
            appletUid: string;
            appletVersion: string;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown>;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            appletUid: string;
            appletVersion: string | undefined;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown> | undefined;
            configurationSet: Record<string, unknown> | undefined;
            configurationRemoveKeys: string[] | undefined;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            uid: string;
            appletUid: string;
            appletVersion: string;
        } | {
            policyUid: string;
            priority: number;
        } | {
            policyUid: string;
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            organizationUid: string;
        } | {
            appletUid: string;
            appletVersion: string;
            tests: string[];
        } | {
            tests: string[];
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
            turnedOn: boolean;
        } | {
            inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
        } | {
            backlight: number;
        } | {
            contrast: number;
        } | {
            sharpness: number;
        } | {
            maxTemperature: number;
        } | {
            enabled: boolean;
            remoteDesktopUri?: string | undefined;
        } | {
            enabled: true;
            healthcheckIntervalMs: number;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            enabled: true;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            deviceIdentityHash: string;
            duration: number;
        } | {
            deviceIdentityHash: string;
        } | {
            deviceIdentityHash: string;
            telemetryCheckIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }, import("@signageos/common-types/dist/BulkOperation/Enums").DeviceActionType>, Partial<Omit<import("../Schema/BulkOperation/bulkOperationModel").IBulkOperation<{
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            version: string;
        } | {
            volume: number;
        } | {
            brightness1: number;
            brightness2: number;
            timeFrom1: string;
            timeFrom2: string;
        } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
            timestamp: number;
            timezone: string | null;
            ntpServer?: string | undefined;
        } | {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        } | {
            version: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            buildHash: string;
            version: string;
            build: string | null;
        } | {
            packageUri: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            specs: object;
        } | {
            powerType: string;
        } | {
            powerType: string;
            weekdays: string[];
            time: string;
        } | {
            scheduledPowerActionUid: string;
        } | {
            enabled: boolean;
        } | {
            resolution: {
                height: number;
                width: number;
                framerate?: number | undefined;
            };
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        } | {
            verificationHash: string;
        } | {
            verificationHash: string;
        } | {
            name: string;
        } | {
            subscriptionType: string | null;
        } | {
            appletUid: string;
            appletVersion: string;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown>;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            appletUid: string;
            appletVersion: string | undefined;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown> | undefined;
            configurationSet: Record<string, unknown> | undefined;
            configurationRemoveKeys: string[] | undefined;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            uid: string;
            appletUid: string;
            appletVersion: string;
        } | {
            policyUid: string;
            priority: number;
        } | {
            policyUid: string;
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            organizationUid: string;
        } | {
            appletUid: string;
            appletVersion: string;
            tests: string[];
        } | {
            tests: string[];
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
            turnedOn: boolean;
        } | {
            inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
        } | {
            backlight: number;
        } | {
            contrast: number;
        } | {
            sharpness: number;
        } | {
            maxTemperature: number;
        } | {
            enabled: boolean;
            remoteDesktopUri?: string | undefined;
        } | {
            enabled: true;
            healthcheckIntervalMs: number;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            enabled: true;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            deviceIdentityHash: string;
            duration: number;
        } | {
            deviceIdentityHash: string;
        } | {
            deviceIdentityHash: string;
            telemetryCheckIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }, import("@signageos/common-types/dist/BulkOperation/Enums").DeviceActionType>, "originator" | "deviceUids" | "failedDeviceUids" | "successfulDeviceUids" | "skippedDeviceUids" | "organizationUids">>, import("./BulkOperation/bulkOperationFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/BulkOperation/bulkOperationModel").IBulkOperation<{
                applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
                version: string;
            } | {
                volume: number;
            } | {
                brightness1: number;
                brightness2: number;
                timeFrom1: string;
                timeFrom2: string;
            } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
                timestamp: number;
                timezone: string | null;
                ntpServer?: string | undefined;
            } | {
                appletEnabled: boolean;
                nativeEnabled: boolean;
            } | {
                version: string;
            } | {
                packageName: string;
                applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
                buildHash: string;
                version: string;
                build: string | null;
            } | {
                packageUri: string;
            } | {
                packageName: string;
                applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
                specs: object;
            } | {
                powerType: string;
            } | {
                powerType: string;
                weekdays: string[];
                time: string;
            } | {
                scheduledPowerActionUid: string;
            } | {
                enabled: boolean;
            } | {
                resolution: {
                    height: number;
                    width: number;
                    framerate?: number | undefined;
                };
                orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
                videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
            } | {
                verificationHash: string;
            } | {
                verificationHash: string;
            } | {
                name: string;
            } | {
                subscriptionType: string | null;
            } | {
                appletUid: string;
                appletVersion: string;
                startsAt: Date | undefined;
                endsAt: Date | undefined;
                configuration: Record<string, unknown>;
                finishEvent: {
                    type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                    data?: any;
                } | undefined;
                position: number | undefined;
                active: boolean | undefined;
            } | {
                appletUid: string;
                appletVersion: string | undefined;
                startsAt: Date | undefined;
                endsAt: Date | undefined;
                configuration: Record<string, unknown> | undefined;
                configurationSet: Record<string, unknown> | undefined;
                configurationRemoveKeys: string[] | undefined;
                finishEvent: {
                    type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
                    data?: any;
                } | undefined;
                position: number | undefined;
                active: boolean | undefined;
            } | {
                uid: string;
                appletUid: string;
                appletVersion: string;
            } | {
                policyUid: string;
                priority: number;
            } | {
                policyUid: string;
            } | {
                deviceIdentityHash: string;
                tagUids: string[];
            } | {
                deviceIdentityHash: string;
                tagUids: string[];
            } | {
                organizationUid: string;
            } | {
                appletUid: string;
                appletVersion: string;
                tests: string[];
            } | {
                tests: string[];
            } | {
                packageName: string;
                applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
                turnedOn: boolean;
            } | {
                inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
            } | {
                backlight: number;
            } | {
                contrast: number;
            } | {
                sharpness: number;
            } | {
                maxTemperature: number;
            } | {
                enabled: boolean;
                remoteDesktopUri?: string | undefined;
            } | {
                enabled: true;
                healthcheckIntervalMs: number;
            } | {
                enabled: false;
                autoEnableTimeoutMs?: number | undefined;
            } | {
                enabled: true;
            } | {
                enabled: false;
                autoEnableTimeoutMs?: number | undefined;
            } | {
                deviceIdentityHash: string;
                duration: number;
            } | {
                deviceIdentityHash: string;
            } | {
                deviceIdentityHash: string;
                telemetryCheckIntervals: {
                    screenshots?: number | undefined;
                    temperature?: number | undefined;
                    applicationVersion?: number | undefined;
                    frontDisplayVersion?: number | undefined;
                    brightness?: number | undefined;
                    datetime?: number | undefined;
                    debug?: number | undefined;
                    firmwareVersion?: number | undefined;
                    orientation?: number | undefined;
                    powerActionsSchedule?: number | undefined;
                    proprietaryTimers?: number | undefined;
                    remoteControl?: number | undefined;
                    resolution?: number | undefined;
                    timers?: number | undefined;
                    volume?: number | undefined;
                    storage?: number | undefined;
                    battery?: number | undefined;
                    policy?: number | undefined;
                    peerRecovery?: number | undefined;
                    autoRecovery?: number | undefined;
                    extendedManagement?: number | undefined;
                    default?: number | undefined;
                };
            }, import("@signageos/common-types/dist/BulkOperation/Enums").DeviceActionType>, "originator" | "deviceUids" | "failedDeviceUids" | "successfulDeviceUids" | "skippedDeviceUids" | "organizationUids">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/BulkOperation/bulkOperationModel").IBulkOperation<{
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            version: string;
        } | {
            volume: number;
        } | {
            brightness1: number;
            brightness2: number;
            timeFrom1: string;
            timeFrom2: string;
        } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
            timestamp: number;
            timezone: string | null;
            ntpServer?: string | undefined;
        } | {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        } | {
            version: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            buildHash: string;
            version: string;
            build: string | null;
        } | {
            packageUri: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            specs: object;
        } | {
            powerType: string;
        } | {
            powerType: string;
            weekdays: string[];
            time: string;
        } | {
            scheduledPowerActionUid: string;
        } | {
            enabled: boolean;
        } | {
            resolution: {
                height: number;
                width: number;
                framerate?: number | undefined;
            };
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        } | {
            verificationHash: string;
        } | {
            verificationHash: string;
        } | {
            name: string;
        } | {
            subscriptionType: string | null;
        } | {
            appletUid: string;
            appletVersion: string;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown>;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            appletUid: string;
            appletVersion: string | undefined;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown> | undefined;
            configurationSet: Record<string, unknown> | undefined;
            configurationRemoveKeys: string[] | undefined;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            uid: string;
            appletUid: string;
            appletVersion: string;
        } | {
            policyUid: string;
            priority: number;
        } | {
            policyUid: string;
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            organizationUid: string;
        } | {
            appletUid: string;
            appletVersion: string;
            tests: string[];
        } | {
            tests: string[];
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
            turnedOn: boolean;
        } | {
            inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
        } | {
            backlight: number;
        } | {
            contrast: number;
        } | {
            sharpness: number;
        } | {
            maxTemperature: number;
        } | {
            enabled: boolean;
            remoteDesktopUri?: string | undefined;
        } | {
            enabled: true;
            healthcheckIntervalMs: number;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            enabled: true;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            deviceIdentityHash: string;
            duration: number;
        } | {
            deviceIdentityHash: string;
        } | {
            deviceIdentityHash: string;
            telemetryCheckIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }, import("@signageos/common-types/dist/BulkOperation/Enums").DeviceActionType>, Partial<Omit<import("../Schema/BulkOperation/bulkOperationModel").IBulkOperation<{
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            version: string;
        } | {
            volume: number;
        } | {
            brightness1: number;
            brightness2: number;
            timeFrom1: string;
            timeFrom2: string;
        } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
            timestamp: number;
            timezone: string | null;
            ntpServer?: string | undefined;
        } | {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        } | {
            version: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            buildHash: string;
            version: string;
            build: string | null;
        } | {
            packageUri: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            specs: object;
        } | {
            powerType: string;
        } | {
            powerType: string;
            weekdays: string[];
            time: string;
        } | {
            scheduledPowerActionUid: string;
        } | {
            enabled: boolean;
        } | {
            resolution: {
                height: number;
                width: number;
                framerate?: number | undefined;
            };
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        } | {
            verificationHash: string;
        } | {
            verificationHash: string;
        } | {
            name: string;
        } | {
            subscriptionType: string | null;
        } | {
            appletUid: string;
            appletVersion: string;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown>;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            appletUid: string;
            appletVersion: string | undefined;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown> | undefined;
            configurationSet: Record<string, unknown> | undefined;
            configurationRemoveKeys: string[] | undefined;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            uid: string;
            appletUid: string;
            appletVersion: string;
        } | {
            policyUid: string;
            priority: number;
        } | {
            policyUid: string;
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            organizationUid: string;
        } | {
            appletUid: string;
            appletVersion: string;
            tests: string[];
        } | {
            tests: string[];
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
            turnedOn: boolean;
        } | {
            inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
        } | {
            backlight: number;
        } | {
            contrast: number;
        } | {
            sharpness: number;
        } | {
            maxTemperature: number;
        } | {
            enabled: boolean;
            remoteDesktopUri?: string | undefined;
        } | {
            enabled: true;
            healthcheckIntervalMs: number;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            enabled: true;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            deviceIdentityHash: string;
            duration: number;
        } | {
            deviceIdentityHash: string;
        } | {
            deviceIdentityHash: string;
            telemetryCheckIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }, import("@signageos/common-types/dist/BulkOperation/Enums").DeviceActionType>, "originator" | "deviceUids" | "failedDeviceUids" | "successfulDeviceUids" | "skippedDeviceUids" | "organizationUids">>, import("./BulkOperation/bulkOperationFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/BulkOperation/bulkOperationModel").IBulkOperation<{
                applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
                version: string;
            } | {
                volume: number;
            } | {
                brightness1: number;
                brightness2: number;
                timeFrom1: string;
                timeFrom2: string;
            } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
                timestamp: number;
                timezone: string | null;
                ntpServer?: string | undefined;
            } | {
                appletEnabled: boolean;
                nativeEnabled: boolean;
            } | {
                version: string;
            } | {
                packageName: string;
                applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
                buildHash: string;
                version: string;
                build: string | null;
            } | {
                packageUri: string;
            } | {
                packageName: string;
                applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
                specs: object;
            } | {
                powerType: string;
            } | {
                powerType: string;
                weekdays: string[];
                time: string;
            } | {
                scheduledPowerActionUid: string;
            } | {
                enabled: boolean;
            } | {
                resolution: {
                    height: number;
                    width: number;
                    framerate?: number | undefined;
                };
                orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
                videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
            } | {
                verificationHash: string;
            } | {
                verificationHash: string;
            } | {
                name: string;
            } | {
                subscriptionType: string | null;
            } | {
                appletUid: string;
                appletVersion: string;
                startsAt: Date | undefined;
                endsAt: Date | undefined;
                configuration: Record<string, unknown>;
                finishEvent: {
                    type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                    data?: any;
                } | undefined;
                position: number | undefined;
                active: boolean | undefined;
            } | {
                appletUid: string;
                appletVersion: string | undefined;
                startsAt: Date | undefined;
                endsAt: Date | undefined;
                configuration: Record<string, unknown> | undefined;
                configurationSet: Record<string, unknown> | undefined;
                configurationRemoveKeys: string[] | undefined;
                finishEvent: {
                    type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
                    data?: any;
                } | undefined;
                position: number | undefined;
                active: boolean | undefined;
            } | {
                uid: string;
                appletUid: string;
                appletVersion: string;
            } | {
                policyUid: string;
                priority: number;
            } | {
                policyUid: string;
            } | {
                deviceIdentityHash: string;
                tagUids: string[];
            } | {
                deviceIdentityHash: string;
                tagUids: string[];
            } | {
                organizationUid: string;
            } | {
                appletUid: string;
                appletVersion: string;
                tests: string[];
            } | {
                tests: string[];
            } | {
                packageName: string;
                applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
                turnedOn: boolean;
            } | {
                inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
            } | {
                backlight: number;
            } | {
                contrast: number;
            } | {
                sharpness: number;
            } | {
                maxTemperature: number;
            } | {
                enabled: boolean;
                remoteDesktopUri?: string | undefined;
            } | {
                enabled: true;
                healthcheckIntervalMs: number;
            } | {
                enabled: false;
                autoEnableTimeoutMs?: number | undefined;
            } | {
                enabled: true;
            } | {
                enabled: false;
                autoEnableTimeoutMs?: number | undefined;
            } | {
                deviceIdentityHash: string;
                duration: number;
            } | {
                deviceIdentityHash: string;
            } | {
                deviceIdentityHash: string;
                telemetryCheckIntervals: {
                    screenshots?: number | undefined;
                    temperature?: number | undefined;
                    applicationVersion?: number | undefined;
                    frontDisplayVersion?: number | undefined;
                    brightness?: number | undefined;
                    datetime?: number | undefined;
                    debug?: number | undefined;
                    firmwareVersion?: number | undefined;
                    orientation?: number | undefined;
                    powerActionsSchedule?: number | undefined;
                    proprietaryTimers?: number | undefined;
                    remoteControl?: number | undefined;
                    resolution?: number | undefined;
                    timers?: number | undefined;
                    volume?: number | undefined;
                    storage?: number | undefined;
                    battery?: number | undefined;
                    policy?: number | undefined;
                    peerRecovery?: number | undefined;
                    autoRecovery?: number | undefined;
                    extendedManagement?: number | undefined;
                    default?: number | undefined;
                };
            }, import("@signageos/common-types/dist/BulkOperation/Enums").DeviceActionType>, "originator" | "deviceUids" | "failedDeviceUids" | "successfulDeviceUids" | "skippedDeviceUids" | "organizationUids">> | undefined;
        }>;
    };
    bulkRequestedEvent: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<{
            createdAt: Date;
            requestUid: string;
            sourceUid: string;
            deviceIdentityHash: string;
        }, Partial<Omit<import("../Schema/BulkOperation/bulkRequestedEventModel").IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">>, {
            device: import("../Schema/Device/deviceModel").IDevice;
            bulkOperation: import("../Schema/BulkOperation/bulkOperationModel").IBulkOperationAlias;
            customFields?: Partial<Omit<import("../Schema/BulkOperation/bulkRequestedEventModel").IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">> | undefined;
        } & {
            customFields?: Partial<Omit<import("../Schema/BulkOperation/bulkRequestedEventModel").IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<{
            createdAt: Date;
            requestUid: string;
            sourceUid: string;
            deviceIdentityHash: string;
        }, Partial<Omit<import("../Schema/BulkOperation/bulkRequestedEventModel").IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">>, {
            device: import("../Schema/Device/deviceModel").IDevice;
            bulkOperation: import("../Schema/BulkOperation/bulkOperationModel").IBulkOperationAlias;
            customFields?: Partial<Omit<import("../Schema/BulkOperation/bulkRequestedEventModel").IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">> | undefined;
        } & {
            customFields?: Partial<Omit<import("../Schema/BulkOperation/bulkRequestedEventModel").IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">> | undefined;
        }>;
    };
    companyNetwork: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/CompanyNetwork/companyNetworkModel").ICompanyNetwork, Partial<Omit<import("../Schema/CompanyNetwork/companyNetworkModel").ICompanyNetwork, "whiteLabelSettingsUid">>, import("./CompanyNetwork/companyNetworkFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/CompanyNetwork/companyNetworkModel").ICompanyNetwork, "whiteLabelSettingsUid">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/CompanyNetwork/companyNetworkModel").ICompanyNetwork, Partial<Omit<import("../Schema/CompanyNetwork/companyNetworkModel").ICompanyNetwork, "whiteLabelSettingsUid">>, import("./CompanyNetwork/companyNetworkFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/CompanyNetwork/companyNetworkModel").ICompanyNetwork, "whiteLabelSettingsUid">> | undefined;
        }>;
    };
    company: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("./Organization/organizationFixtures").Company, Partial<Omit<import("../Schema/Organization/organizationModel").IOrganization, import("./Organization/organizationFixtures").CompanyOmitFields>>, import("./Organization/organizationFixtures").CreateCompanyProps & {
            customFields?: Partial<Omit<import("../Schema/Organization/organizationModel").IOrganization, import("./Organization/organizationFixtures").CompanyOmitFields>> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("./Organization/organizationFixtures").Company, Partial<Omit<import("../Schema/Organization/organizationModel").IOrganization, import("./Organization/organizationFixtures").CompanyOmitFields>>, import("./Organization/organizationFixtures").CreateCompanyProps & {
            customFields?: Partial<Omit<import("../Schema/Organization/organizationModel").IOrganization, import("./Organization/organizationFixtures").CompanyOmitFields>> | undefined;
        }>;
    };
    organization: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("./Organization/organizationFixtures").Organization, Partial<Omit<import("../Schema/Organization/organizationModel").IOrganization, import("./Organization/organizationFixtures").OrganizationOmitFields>>, import("./Organization/organizationFixtures").CreateOrganizationProps & {
            customFields?: Partial<Omit<import("../Schema/Organization/organizationModel").IOrganization, import("./Organization/organizationFixtures").OrganizationOmitFields>> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("./Organization/organizationFixtures").Organization, Partial<Omit<import("../Schema/Organization/organizationModel").IOrganization, import("./Organization/organizationFixtures").OrganizationOmitFields>>, import("./Organization/organizationFixtures").CreateOrganizationProps & {
            customFields?: Partial<Omit<import("../Schema/Organization/organizationModel").IOrganization, import("./Organization/organizationFixtures").OrganizationOmitFields>> | undefined;
        }>;
    };
    uiTheme: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/UITheme/uiThemeModel").IUITheme, Partial<import("../Schema/UITheme/uiThemeModel").IUITheme>, import("./UITheme/uiThemeFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/UITheme/uiThemeModel").IUITheme> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/UITheme/uiThemeModel").IUITheme, Partial<import("../Schema/UITheme/uiThemeModel").IUITheme>, import("./UITheme/uiThemeFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/UITheme/uiThemeModel").IUITheme> | undefined;
        }>;
    };
    whiteLabelSettings: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/WhiteLabelSettings/whiteLabelSettingsModel").IWhiteLabelSettings, Partial<Omit<import("../Schema/WhiteLabelSettings/whiteLabelSettingsModel").IWhiteLabelSettings, "uiThemeUid">>, import("./WhiteLabelSettings/whiteLabelSettingsFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/WhiteLabelSettings/whiteLabelSettingsModel").IWhiteLabelSettings, "uiThemeUid">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/WhiteLabelSettings/whiteLabelSettingsModel").IWhiteLabelSettings, Partial<Omit<import("../Schema/WhiteLabelSettings/whiteLabelSettingsModel").IWhiteLabelSettings, "uiThemeUid">>, import("./WhiteLabelSettings/whiteLabelSettingsFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/WhiteLabelSettings/whiteLabelSettingsModel").IWhiteLabelSettings, "uiThemeUid">> | undefined;
        }>;
    };
    device: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Device/deviceModel").IDevice, Partial<import("../Schema/Device/deviceModel").IDevice>, import("./Device/deviceFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Device/deviceModel").IDevice> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Device/deviceModel").IDevice, Partial<import("../Schema/Device/deviceModel").IDevice>, import("./Device/deviceFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Device/deviceModel").IDevice> | undefined;
        }>;
    };
    deviceInfo: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Device/Info/deviceInfoModel").IDeviceInfo & {
            minStorageStatusFreeSpacePercentage: number;
        }, Partial<Omit<import("../Schema/Device/Info/deviceInfoModel").IDeviceInfo, "identityHash">>, import("./Device/DeviceInfo/deviceInfoFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/Info/deviceInfoModel").IDeviceInfo, "identityHash">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Device/Info/deviceInfoModel").IDeviceInfo & {
            minStorageStatusFreeSpacePercentage: number;
        }, Partial<Omit<import("../Schema/Device/Info/deviceInfoModel").IDeviceInfo, "identityHash">>, import("./Device/DeviceInfo/deviceInfoFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/Info/deviceInfoModel").IDeviceInfo, "identityHash">> | undefined;
        }>;
    };
    deviceConfiguration: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Device/Configuration/deviceConfigurationModel").IDeviceConfiguration, Partial<Omit<import("../Schema/Device/Configuration/deviceConfigurationModel").IDeviceConfiguration, "deviceIdentityHash">>, import("./Device/Configuration/deviceConfigurationFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/Configuration/deviceConfigurationModel").IDeviceConfiguration, "deviceIdentityHash">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Device/Configuration/deviceConfigurationModel").IDeviceConfiguration, Partial<Omit<import("../Schema/Device/Configuration/deviceConfigurationModel").IDeviceConfiguration, "deviceIdentityHash">>, import("./Device/Configuration/deviceConfigurationFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/Configuration/deviceConfigurationModel").IDeviceConfiguration, "deviceIdentityHash">> | undefined;
        }>;
    };
    deviceVerification: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Device/Verification/deviceVerificationModel").IDeviceVerification, Partial<Omit<import("../Schema/Device/Verification/deviceVerificationModel").IDeviceVerification, "deviceIdentityHash">>, import("./Device/deviceVerificationFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/Verification/deviceVerificationModel").IDeviceVerification, "deviceIdentityHash">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Device/Verification/deviceVerificationModel").IDeviceVerification, Partial<Omit<import("../Schema/Device/Verification/deviceVerificationModel").IDeviceVerification, "deviceIdentityHash">>, import("./Device/deviceVerificationFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/Verification/deviceVerificationModel").IDeviceVerification, "deviceIdentityHash">> | undefined;
        }>;
    };
    deviceScreenshot: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Device/Screenshot/deviceScreenshotModel").IDeviceScreenshot, Partial<Omit<import("../Schema/Device/Screenshot/deviceScreenshotModel").IDeviceScreenshot, "deviceIdentityHash">>, import("./Device/Screenshot/screenshotFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/Screenshot/deviceScreenshotModel").IDeviceScreenshot, "deviceIdentityHash">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Device/Screenshot/deviceScreenshotModel").IDeviceScreenshot, Partial<Omit<import("../Schema/Device/Screenshot/deviceScreenshotModel").IDeviceScreenshot, "deviceIdentityHash">>, import("./Device/Screenshot/screenshotFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/Screenshot/deviceScreenshotModel").IDeviceScreenshot, "deviceIdentityHash">> | undefined;
        }>;
    };
    deviceActionLog: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Device/ActionLog/deviceActionLogModel").IDeviceActionLog<import("../Schema/Device/ActionLog/deviceActionLogModel").DeviceActionType>, Partial<Omit<import("../Schema/Device/ActionLog/deviceActionLogModel").IDeviceActionLog<any>, "deviceIdentityHash">>, import("./Device/ActionLog/deviceActionLogFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/ActionLog/deviceActionLogModel").IDeviceActionLog<any>, "deviceIdentityHash">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Device/ActionLog/deviceActionLogModel").IDeviceActionLog<import("../Schema/Device/ActionLog/deviceActionLogModel").DeviceActionType>, Partial<Omit<import("../Schema/Device/ActionLog/deviceActionLogModel").IDeviceActionLog<any>, "deviceIdentityHash">>, import("./Device/ActionLog/deviceActionLogFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/ActionLog/deviceActionLogModel").IDeviceActionLog<any>, "deviceIdentityHash">> | undefined;
        }>;
    };
    devicePowerAction: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Device/PowerAction/devicePowerActionModel").IDevicePowerAction, Partial<Omit<import("../Schema/Device/PowerAction/devicePowerActionModel").IDevicePowerAction, "deviceIdentityHash">>, import("./Device/PowerAction/devicePowerActionFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/PowerAction/devicePowerActionModel").IDevicePowerAction, "deviceIdentityHash">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Device/PowerAction/devicePowerActionModel").IDevicePowerAction, Partial<Omit<import("../Schema/Device/PowerAction/devicePowerActionModel").IDevicePowerAction, "deviceIdentityHash">>, import("./Device/PowerAction/devicePowerActionFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Device/PowerAction/devicePowerActionModel").IDevicePowerAction, "deviceIdentityHash">> | undefined;
        }>;
    };
    deviceSession: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Device/Session/deviceSessionModel").IDeviceSession, Partial<import("../Schema/Device/Session/deviceSessionModel").IDeviceSession>, import("./Device/Session/deviceSessionFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Device/Session/deviceSessionModel").IDeviceSession> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Device/Session/deviceSessionModel").IDeviceSession, Partial<import("../Schema/Device/Session/deviceSessionModel").IDeviceSession>, import("./Device/Session/deviceSessionFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Device/Session/deviceSessionModel").IDeviceSession> | undefined;
        }>;
    };
    issuedServerLicense: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/License/issuedServerLicenseModel").IIssuedServerLicense, Partial<Omit<import("../Schema/License/issuedServerLicenseModel").IIssuedServerLicense, "organizationUid">>, import("./License/issuedServerLicenseFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/License/issuedServerLicenseModel").IIssuedServerLicense, "organizationUid">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/License/issuedServerLicenseModel").IIssuedServerLicense, Partial<Omit<import("../Schema/License/issuedServerLicenseModel").IIssuedServerLicense, "organizationUid">>, import("./License/issuedServerLicenseFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/License/issuedServerLicenseModel").IIssuedServerLicense, "organizationUid">> | undefined;
        }>;
    };
    issuedServerLicenseValidity: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/License/issuedServerLicenseValidityModel").IIssuedServerLicenseValidity, Partial<Omit<import("../Schema/License/issuedServerLicenseValidityModel").IIssuedServerLicenseValidity, "issuedServerLicenseId">>, import("./License/issuedServerLicenseValidityFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/License/issuedServerLicenseValidityModel").IIssuedServerLicenseValidity, "issuedServerLicenseId">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/License/issuedServerLicenseValidityModel").IIssuedServerLicenseValidity, Partial<Omit<import("../Schema/License/issuedServerLicenseValidityModel").IIssuedServerLicenseValidity, "issuedServerLicenseId">>, import("./License/issuedServerLicenseValidityFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/License/issuedServerLicenseValidityModel").IIssuedServerLicenseValidity, "issuedServerLicenseId">> | undefined;
        }>;
    };
    issuedDeviceLicense: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/License/issuedDeviceLicenseModel").IIssuedDeviceLicense, Partial<Omit<import("../Schema/License/issuedDeviceLicenseModel").IIssuedDeviceLicense, "organizationUid">>, import("./License/issuedDeviceLicenseFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/License/issuedDeviceLicenseModel").IIssuedDeviceLicense, "organizationUid">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/License/issuedDeviceLicenseModel").IIssuedDeviceLicense, Partial<Omit<import("../Schema/License/issuedDeviceLicenseModel").IIssuedDeviceLicense, "organizationUid">>, import("./License/issuedDeviceLicenseFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/License/issuedDeviceLicenseModel").IIssuedDeviceLicense, "organizationUid">> | undefined;
        }>;
    };
    ownServerLicense: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/License/ownServerLicenseModel").IOwnServerLicense, Partial<import("../Schema/License/ownServerLicenseModel").IOwnServerLicense>, import("./License/ownServerLicenseFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/License/ownServerLicenseModel").IOwnServerLicense> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/License/ownServerLicenseModel").IOwnServerLicense, Partial<import("../Schema/License/ownServerLicenseModel").IOwnServerLicense>, import("./License/ownServerLicenseFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/License/ownServerLicenseModel").IOwnServerLicense> | undefined;
        }>;
    };
    ownServerLicenseValidity: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/License/ownServerLicenseValidityModel").IOwnServerLicenseValidity, Partial<Omit<import("../Schema/License/ownServerLicenseValidityModel").IOwnServerLicenseValidity, "ownServerLicenseId">>, import("./License/ownServerLicenseValidityFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/License/ownServerLicenseValidityModel").IOwnServerLicenseValidity, "ownServerLicenseId">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/License/ownServerLicenseValidityModel").IOwnServerLicenseValidity, Partial<Omit<import("../Schema/License/ownServerLicenseValidityModel").IOwnServerLicenseValidity, "ownServerLicenseId">>, import("./License/ownServerLicenseValidityFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/License/ownServerLicenseValidityModel").IOwnServerLicenseValidity, "ownServerLicenseId">> | undefined;
        }>;
    };
    termsAndConditions: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/TermsAndConditions/termsAndConditionsModel").ITermsAndConditions, Partial<import("../Schema/TermsAndConditions/termsAndConditionsModel").ITermsAndConditions>, import("./TermsAndConditions/termsAndConditionsFixtures").ICreateTermsAndConditionsParams & {
            customFields?: Partial<import("../Schema/TermsAndConditions/termsAndConditionsModel").ITermsAndConditions> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/TermsAndConditions/termsAndConditionsModel").ITermsAndConditions, Partial<import("../Schema/TermsAndConditions/termsAndConditionsModel").ITermsAndConditions>, import("./TermsAndConditions/termsAndConditionsFixtures").ICreateTermsAndConditionsParams & {
            customFields?: Partial<import("../Schema/TermsAndConditions/termsAndConditionsModel").ITermsAndConditions> | undefined;
        }>;
    };
    termsAndConditionsVersion: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/TermsAndConditionsVersion/termsAndConditionsVersionModel").ITermsAndConditionsVersion, Partial<import("../Schema/TermsAndConditionsVersion/termsAndConditionsVersionModel").ITermsAndConditionsVersion>, import("./TermsAndConditionsVersion/termsAndConditionsVersionFixtures").ICreateTermsAndConditionsVersionParams & {
            customFields?: Partial<import("../Schema/TermsAndConditionsVersion/termsAndConditionsVersionModel").ITermsAndConditionsVersion> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/TermsAndConditionsVersion/termsAndConditionsVersionModel").ITermsAndConditionsVersion, Partial<import("../Schema/TermsAndConditionsVersion/termsAndConditionsVersionModel").ITermsAndConditionsVersion>, import("./TermsAndConditionsVersion/termsAndConditionsVersionFixtures").ICreateTermsAndConditionsVersionParams & {
            customFields?: Partial<import("../Schema/TermsAndConditionsVersion/termsAndConditionsVersionModel").ITermsAndConditionsVersion> | undefined;
        }>;
    };
    policyLog: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Policy/policyLogModel").IPolicyLog<import("../Schema/Policy/policyModel").PolicyBase>, Partial<Omit<import("../Schema/Policy/policyLogModel").IPolicyLog<import("../Schema/Policy/policyModel").PolicyBase>, "organizationUid">>, import("./PolicyLog/policyLogFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Policy/policyLogModel").IPolicyLog<import("../Schema/Policy/policyModel").PolicyBase>, "organizationUid">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Policy/policyLogModel").IPolicyLog<import("../Schema/Policy/policyModel").PolicyBase>, Partial<Omit<import("../Schema/Policy/policyLogModel").IPolicyLog<import("../Schema/Policy/policyModel").PolicyBase>, "organizationUid">>, import("./PolicyLog/policyLogFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Policy/policyLogModel").IPolicyLog<import("../Schema/Policy/policyModel").PolicyBase>, "organizationUid">> | undefined;
        }>;
    };
    policy: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Policy/policyModel").IPolicy, Partial<Omit<import("../Schema/Policy/policyModel").IPolicy, "organizationUid">>, import("./Policy/policyFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Policy/policyModel").IPolicy, "organizationUid">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Policy/policyModel").IPolicy, Partial<Omit<import("../Schema/Policy/policyModel").IPolicy, "organizationUid">>, import("./Policy/policyFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Policy/policyModel").IPolicy, "organizationUid">> | undefined;
        }>;
    };
    package: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Package/packageModel").IPackage, Partial<Omit<import("../Schema/Package/packageModel").IPackage, "ownerOrganizationUid" | "createdByAccountId">>, import("./Package/packageFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Package/packageModel").IPackage, "ownerOrganizationUid" | "createdByAccountId">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Package/packageModel").IPackage, Partial<Omit<import("../Schema/Package/packageModel").IPackage, "ownerOrganizationUid" | "createdByAccountId">>, import("./Package/packageFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Package/packageModel").IPackage, "ownerOrganizationUid" | "createdByAccountId">> | undefined;
        }>;
    };
    packageVersion: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Package/packageVersionModel").IPackageVersion, Partial<Omit<import("../Schema/Package/packageVersionModel").IPackageVersion, "packageName">>, import("./Package/packageVersionFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Package/packageVersionModel").IPackageVersion, "packageName">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Package/packageVersionModel").IPackageVersion, Partial<Omit<import("../Schema/Package/packageVersionModel").IPackageVersion, "packageName">>, import("./Package/packageVersionFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Package/packageVersionModel").IPackageVersion, "packageName">> | undefined;
        }>;
    };
    organizationTag: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Organization/Tag/organizationTagModel").IOrganizationTag, Omit<Partial<import("../Schema/Organization/Tag/organizationTagModel").IOrganizationTag>, "organizationUid">, import("./Organization/organizationTagFixtures").CreateProps & {
            customFields?: Omit<Partial<import("../Schema/Organization/Tag/organizationTagModel").IOrganizationTag>, "organizationUid"> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Organization/Tag/organizationTagModel").IOrganizationTag, Omit<Partial<import("../Schema/Organization/Tag/organizationTagModel").IOrganizationTag>, "organizationUid">, import("./Organization/organizationTagFixtures").CreateProps & {
            customFields?: Omit<Partial<import("../Schema/Organization/Tag/organizationTagModel").IOrganizationTag>, "organizationUid"> | undefined;
        }>;
    };
    applet: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Applet/appletModel").IApplet, Partial<import("../Schema/Applet/appletModel").IApplet>, import("./Applet/appletFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Applet/appletModel").IApplet> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Applet/appletModel").IApplet, Partial<import("../Schema/Applet/appletModel").IApplet>, import("./Applet/appletFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Applet/appletModel").IApplet> | undefined;
        }>;
    };
    appletVersion: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Applet/Version/appletVersionModel").IAppletVersion, Partial<Omit<import("../Schema/Applet/Version/appletVersionModel").IAppletVersion, "appletUid">>, import("./Applet/appletVersionFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Applet/Version/appletVersionModel").IAppletVersion, "appletUid">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Applet/Version/appletVersionModel").IAppletVersion, Partial<Omit<import("../Schema/Applet/Version/appletVersionModel").IAppletVersion, "appletUid">>, import("./Applet/appletVersionFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/Applet/Version/appletVersionModel").IAppletVersion, "appletUid">> | undefined;
        }>;
    };
    timing: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Timing/timingModel").ITiming, Partial<import("../Schema/Timing/timingModel").ITiming>, import("./Timing/timingFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Timing/timingModel").ITiming> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Timing/timingModel").ITiming, Partial<import("../Schema/Timing/timingModel").ITiming>, import("./Timing/timingFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Timing/timingModel").ITiming> | undefined;
        }>;
    };
    timingCommand: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Timing/Command/timingCommandModel").ITimingCommand, Partial<import("../Schema/Timing/Command/timingCommandModel").ITimingCommand>, import("./Timing/Command/timingCommandFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Timing/Command/timingCommandModel").ITimingCommand> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Timing/Command/timingCommandModel").ITimingCommand, Partial<import("../Schema/Timing/Command/timingCommandModel").ITimingCommand>, import("./Timing/Command/timingCommandFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Timing/Command/timingCommandModel").ITimingCommand> | undefined;
        }>;
    };
    location: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Location/locationModel").ILocation, Partial<import("../Schema/Location/locationModel").ILocation>, import("./Location/locationFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Location/locationModel").ILocation> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Location/locationModel").ILocation, Partial<import("../Schema/Location/locationModel").ILocation>, import("./Location/locationFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Location/locationModel").ILocation> | undefined;
        }>;
    };
    deviceProvisioningRecipe: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/Device/ProvisioningRecipe/deviceProvisioningRecipeModel").IDeviceProvisioningRecipe, Partial<import("../Schema/Device/ProvisioningRecipe/deviceProvisioningRecipeModel").IDeviceProvisioningRecipe>, import("./Device/ProvisioningRecipe/deviceProvisioningRecipeFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Device/ProvisioningRecipe/deviceProvisioningRecipeModel").IDeviceProvisioningRecipe> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/Device/ProvisioningRecipe/deviceProvisioningRecipeModel").IDeviceProvisioningRecipe, Partial<import("../Schema/Device/ProvisioningRecipe/deviceProvisioningRecipeModel").IDeviceProvisioningRecipe>, import("./Device/ProvisioningRecipe/deviceProvisioningRecipeFixtures").CreateProps & {
            customFields?: Partial<import("../Schema/Device/ProvisioningRecipe/deviceProvisioningRecipeModel").IDeviceProvisioningRecipe> | undefined;
        }>;
    };
    systemLog: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/SystemLog/systemLogModel").ISystemLog, Partial<Omit<import("../Schema/SystemLog/systemLogModel").ISystemLog, "deviceIdentityHash">>, import("./SystemLog/systemLogFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/SystemLog/systemLogModel").ISystemLog, "deviceIdentityHash">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/SystemLog/systemLogModel").ISystemLog, Partial<Omit<import("../Schema/SystemLog/systemLogModel").ISystemLog, "deviceIdentityHash">>, import("./SystemLog/systemLogFixtures").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/SystemLog/systemLogModel").ISystemLog, "deviceIdentityHash">> | undefined;
        }>;
    };
    thirdPartyCredentials: {
        createSimpleFactory(): import("../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, Partial<Omit<import("../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, "uid" | "organizationUid">>, import("./ThirdPartyCredentials/thirdPartyCredentialsFactories").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, "uid" | "organizationUid">> | undefined;
        }>;
        createMongoFactory(mongodbConnection: IMongodbConnection): import("../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, Partial<Omit<import("../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, "uid" | "organizationUid">>, import("./ThirdPartyCredentials/thirdPartyCredentialsFactories").CreateProps & {
            customFields?: Partial<Omit<import("../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, "uid" | "organizationUid">> | undefined;
        }>;
    };
};
declare type FixturesFactories = typeof fixturesFactories;
declare type SimpleFixturesFactories = {
    [K in keyof FixturesFactories]: ReturnType<FixturesFactories[K]['createSimpleFactory']>;
};
declare type MongoFixturesFactories = {
    [K in keyof FixturesFactories]: ReturnType<FixturesFactories[K]['createMongoFactory']>;
};
/**
 * Returns a map of all simple fixture factories
 *
 * Simple fixture factories don't use any database and just create fixtures in memory
 */
export declare function createSimpleFixtureFactories(): SimpleFixturesFactories;
/**
 * Returns a map of all MongoDB fixture factories
 *
 * All fixtures created by these fixture factories are saved to MongoDB database via the provided mongodbConnection
 */
export declare function createMongoFixtureFactories(mongoConnection: IMongodbConnection): MongoFixturesFactories;
export {};
//# sourceMappingURL=fixturesFactories.d.ts.map