"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWhiteLabelSettingsFixturesFactories = exports.createWhiteLabelSettings = void 0;
const faker_1 = require("@faker-js/faker");
const uid_1 = require("@signageos/common-types/dist/Entity/uid");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
function createWhiteLabelSettings({ uiTheme, termsAndConditions, customFields }) {
    return Object.assign(Object.assign({ uid: (0, uid_1.generateUid)(), customDomain: faker_1.faker.internet.domainName(), emailFooter: faker_1.faker.lorem.sentence(), notificationEmailAddress: faker_1.faker.internet.email(), notificationEmailName: faker_1.faker.company.companyName(), pageTitle: faker_1.faker.commerce.productName(), uiThemeUid: uiTheme.uid, disabledEmailTypes: [], disabledFeatures: [], auth0Config: {
            domain: faker_1.faker.internet.domainName(),
            clientId: faker_1.faker.datatype.uuid(),
            connectionId: `con_${faker_1.faker.random.alphaNumeric(16)}`,
        }, createdAt: faker_1.faker.date.past(), updatedAt: faker_1.faker.date.past() }, ((termsAndConditions === null || termsAndConditions === void 0 ? void 0 : termsAndConditions.uid) && { termsAndConditionsUid: termsAndConditions === null || termsAndConditions === void 0 ? void 0 : termsAndConditions.uid })), customFields);
}
exports.createWhiteLabelSettings = createWhiteLabelSettings;
function createWhiteLabelSettingsFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.WhiteLabelSettings,
        createEntity: createWhiteLabelSettings,
    });
}
exports.createWhiteLabelSettingsFixturesFactories = createWhiteLabelSettingsFixturesFactories;
//# sourceMappingURL=whiteLabelSettingsFixtures.js.map