"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createUIThemeFixturesFactories = exports.createUITheme = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
function createUITheme({ customFields }) {
    return Object.assign({ uid: faker_1.faker.datatype.uuid(), logo: faker_1.faker.internet.url(), topBarBackgroundColor1: faker_1.faker.internet.color(), topBarBackgroundColor2: faker_1.faker.internet.color(), tabsCardActiveColor: faker_1.faker.internet.color(), tabsCardActiveBackground: faker_1.faker.internet.color(), btnPrimaryColor: faker_1.faker.internet.color(), btnPrimaryBackground: faker_1.faker.internet.color(), menuItemColor: faker_1.faker.internet.color(), menuItemHoverBackground: faker_1.faker.internet.color(), menuItemActiveBackground: faker_1.faker.internet.color(), hideMenuButtonColor: faker_1.faker.internet.color(), textColor: faker_1.faker.internet.color(), cardTitleColor: faker_1.faker.internet.color(), favicon: faker_1.faker.internet.avatar(), createdAt: faker_1.faker.date.past(), updatedAt: faker_1.faker.date.past() }, customFields);
}
exports.createUITheme = createUITheme;
function createUIThemeFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.UiTheme,
        createEntity: createUITheme,
    });
}
exports.createUIThemeFixturesFactories = createUIThemeFixturesFactories;
//# sourceMappingURL=uiThemeFixtures.js.map