"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTimingFixturesFactories = exports.createTiming = void 0;
const faker_1 = require("@faker-js/faker");
const uid_1 = require("@signageos/common-types/dist/Entity/uid");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createTiming({ applet, device, customFields }) {
    return Object.assign({ uid: (0, uid_1.generateUid)(), deviceIdentityHash: device.identityHash, appletUid: applet.uid, createdAt: faker_1.faker.date.past(), updatedAt: faker_1.faker.date.past(), startsAt: faker_1.faker.date.past(), endsAt: faker_1.faker.date.past(), configuration: {
            identification: faker_1.faker.datatype.uuid(),
        }, finishEvent: {
            type: faker_1.faker.random.word(),
            data: faker_1.faker.random.word(),
        }, appletVersion: faker_1.faker.system.semver(), position: faker_1.faker.datatype.number({ min: 0, max: 100 }), active: faker_1.faker.datatype.boolean() }, customFields);
}
exports.createTiming = createTiming;
function createTimingFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.Timing,
        createEntity: createTiming,
    });
}
exports.createTimingFixturesFactories = createTimingFixturesFactories;
//# sourceMappingURL=timingFixtures.js.map