"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTimingCommandFixturesFactories = exports.createTimingCommand = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../../Mongo/Lib/collections");
function createTimingCommand({ applet, device, customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), commandPayload: {
            type: faker_1.faker.random.word(),
        }, deviceIdentityHash: device.identityHash, appletUid: applet.uid, timingChecksum: faker_1.faker.random.alphaNumeric(10), receivedAt: faker_1.faker.date.past(), recordedAt: faker_1.faker.date.past() }, customFields);
}
exports.createTimingCommand = createTimingCommand;
function createTimingCommandFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.TimingCommand,
        createEntity: createTimingCommand,
    });
}
exports.createTimingCommandFixturesFactories = createTimingCommandFixturesFactories;
//# sourceMappingURL=timingCommandFixtures.js.map