import { IApplet } from '../../../Schema/Applet/appletModel';
import { IDevice } from '../../../Schema/Device/deviceModel';
import { ITimingCommand } from '../../../Schema/Timing/Command/timingCommandModel';
export declare type CustomFields = Partial<ITimingCommand>;
export interface CreateProps {
    customFields?: CustomFields;
    applet: IApplet;
    device: IDevice;
}
export declare function createTimingCommand({ applet, device, customFields }: CreateProps): ITimingCommand;
export declare function createTimingCommandFixturesFactories(): {
    createSimpleFactory(): import("../../../Lib/Fixtures/fixturesFactory").IFixturesFactory<ITimingCommand, Partial<ITimingCommand>, CreateProps & {
        customFields?: Partial<ITimingCommand> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<ITimingCommand, Partial<ITimingCommand>, CreateProps & {
        customFields?: Partial<ITimingCommand> | undefined;
    }>;
};
//# sourceMappingURL=timingCommandFixtures.d.ts.map