"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createThirdPartyCredentialsFixturesFactories = exports.createThirdPartyCredentials = exports.createCredentialsPayloadByType = void 0;
const generators_1 = require("@signageos/commands/dist/generators");
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createCredentialsPayloadByType(type) {
    switch (type) {
        case 'google':
            return {
                type,
                customerId: faker_1.default.datatype.uuid(),
                clientEmail: faker_1.default.internet.email(),
                privateKey: faker_1.default.internet.password(),
            };
        default:
            throw new Error(`Unknown third party type: ${type}`);
    }
}
exports.createCredentialsPayloadByType = createCredentialsPayloadByType;
function createThirdPartyCredentials({ organization, customFields, type }) {
    return Object.assign(Object.assign({ uid: (0, generators_1.uid)(), createdAt: faker_1.default.datatype.datetime(), updatedAt: faker_1.default.datatype.datetime(), organizationUid: organization.uid }, createCredentialsPayloadByType(type)), customFields);
}
exports.createThirdPartyCredentials = createThirdPartyCredentials;
function createThirdPartyCredentialsFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.ThirdPartyCredentials,
        createEntity: createThirdPartyCredentials,
    });
}
exports.createThirdPartyCredentialsFixturesFactories = createThirdPartyCredentialsFixturesFactories;
//# sourceMappingURL=thirdPartyCredentialsFactories.js.map