import { IThirdPartyCredentials } from '../../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel';
import { IOrganization } from '../../Schema/Organization/organizationModel';
export interface CreateProps {
    organization: IOrganization;
    type: IThirdPartyCredentials['type'];
    customFields?: Partial<Omit<IThirdPartyCredentials, 'organizationUid' | 'uid'>>;
}
export declare function createCredentialsPayloadByType(type: IThirdPartyCredentials['type']): Omit<IThirdPartyCredentials, 'uid' | 'createdAt' | 'updatedAt' | 'organizationUid'>;
export declare function createThirdPartyCredentials({ organization, customFields, type }: CreateProps): IThirdPartyCredentials;
export declare function createThirdPartyCredentialsFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<import("../../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, Partial<Omit<import("../../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, "uid" | "organizationUid">>, CreateProps & {
        customFields?: Partial<Omit<import("../../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, "uid" | "organizationUid">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<import("../../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, Partial<Omit<import("../../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, "uid" | "organizationUid">>, CreateProps & {
        customFields?: Partial<Omit<import("../../Schema/ThirdPartyCredentials/thirdPartyCredentialsModel").IGoogleCredentials, "uid" | "organizationUid">> | undefined;
    }>;
};
//# sourceMappingURL=thirdPartyCredentialsFactories.d.ts.map