"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTermsAndConditionsFixturesFactories = exports.createTermsAndConditions = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const createTermsAndConditions = ({ customFields }) => {
    const createdAt = faker_1.faker.date.past();
    return Object.assign({ uid: faker_1.faker.datatype.uuid(), name: faker_1.faker.name.jobArea(), createdAt, updatedAt: faker_1.faker.date.between(createdAt, new Date()) }, customFields);
};
exports.createTermsAndConditions = createTermsAndConditions;
function createTermsAndConditionsFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.TermsAndConditions,
        createEntity: exports.createTermsAndConditions,
    });
}
exports.createTermsAndConditionsFixturesFactories = createTermsAndConditionsFixturesFactories;
//# sourceMappingURL=termsAndConditionsFixtures.js.map