"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSystemLogFixturesFactories = exports.createSystemLog = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
function createSystemLog({ device, customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), payload: {
            type: faker_1.faker.hacker.adjective(),
        }, deviceIdentityHash: device.identityHash, receivedAt: faker_1.faker.datatype.datetime(), recordedAt: faker_1.faker.datatype.datetime() }, customFields);
}
exports.createSystemLog = createSystemLog;
function createSystemLogFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.SystemLog,
        createEntity: createSystemLog,
    });
}
exports.createSystemLogFixturesFactories = createSystemLogFixturesFactories;
//# sourceMappingURL=systemLogFixtures.js.map