import { IDevice } from '../../Schema/Device/deviceModel';
import { ISystemLog } from '../../Schema/SystemLog/systemLogModel';
export declare type CustomFields = Partial<Omit<ISystemLog, 'deviceIdentityHash'>>;
export interface CreateProps {
    device: IDevice;
    customFields?: CustomFields;
}
export declare function createSystemLog({ device, customFields }: CreateProps): ISystemLog;
export declare function createSystemLogFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<ISystemLog, Partial<Omit<ISystemLog, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<ISystemLog, "deviceIdentityHash">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<ISystemLog, Partial<Omit<ISystemLog, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<ISystemLog, "deviceIdentityHash">> | undefined;
    }>;
};
//# sourceMappingURL=systemLogFixtures.d.ts.map