"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPolicyLogFixturesFactories = exports.createPolicyLog = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
function createPolicyLog({ organization, customFields }) {
    return Object.assign({ uid: faker_1.faker.datatype.uuid(), name: faker_1.faker.hacker.adjective(), organizationUid: organization.uid, items: [], archived: false, createdAt: faker_1.faker.datatype.datetime(), updatedAt: faker_1.faker.datatype.datetime(), originator: {} }, customFields);
}
exports.createPolicyLog = createPolicyLog;
function createPolicyLogFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.PolicyLog,
        createEntity: createPolicyLog,
    });
}
exports.createPolicyLogFixturesFactories = createPolicyLogFixturesFactories;
//# sourceMappingURL=policyLogFixtures.js.map