import { IPolicyLog } from '../../Schema/Policy/policyLogModel';
import { PolicyBase } from '../../Schema/Policy/policyModel';
import { IOrganization } from '../../Schema/Organization/organizationModel';
export declare type CustomFields = Partial<Omit<IPolicyLog<PolicyBase>, 'organizationUid'>>;
export interface CreateProps {
    organization: IOrganization;
    customFields?: CustomFields;
}
export declare function createPolicyLog({ organization, customFields }: CreateProps): IPolicyLog<PolicyBase>;
export declare function createPolicyLogFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IPolicyLog<PolicyBase>, Partial<Omit<IPolicyLog<PolicyBase>, "organizationUid">>, CreateProps & {
        customFields?: Partial<Omit<IPolicyLog<PolicyBase>, "organizationUid">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IPolicyLog<PolicyBase>, Partial<Omit<IPolicyLog<PolicyBase>, "organizationUid">>, CreateProps & {
        customFields?: Partial<Omit<IPolicyLog<PolicyBase>, "organizationUid">> | undefined;
    }>;
};
//# sourceMappingURL=policyLogFixtures.d.ts.map