import { IOrganization } from '../../Schema/Organization/organizationModel';
import { IPolicy } from '../../Schema/Policy/policyModel';
export declare type CustomFields = Partial<Omit<IPolicy, 'organizationUid'>>;
export interface CreateProps {
    organization: IOrganization;
    customFields?: CustomFields;
}
export declare function createPolicy({ organization, customFields }: CreateProps): IPolicy;
export declare function createPolicyFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IPolicy, Partial<Omit<IPolicy, "organizationUid">>, CreateProps & {
        customFields?: Partial<Omit<IPolicy, "organizationUid">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IPolicy, Partial<Omit<IPolicy, "organizationUid">>, CreateProps & {
        customFields?: Partial<Omit<IPolicy, "organizationUid">> | undefined;
    }>;
};
//# sourceMappingURL=policyFixtures.d.ts.map