"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPackageVersionFixturesFactories = exports.createPackageVersion = void 0;
const faker_1 = require("@faker-js/faker");
const applicationType_1 = require("../Application/applicationType");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createPackageVersion({ packageObject, customFields }) {
    return Object.assign({ uid: faker_1.faker.datatype.uuid(), packageName: packageObject.packageName, createdAt: faker_1.faker.datatype.datetime(), applicationType: faker_1.faker.helpers.arrayElement(applicationType_1.applicationTypes), version: faker_1.faker.hacker.noun(), build: faker_1.faker.datatype.uuid(), iconUrl: faker_1.faker.image.imageUrl(), buildHash: faker_1.faker.internet.password() }, customFields);
}
exports.createPackageVersion = createPackageVersion;
function createPackageVersionFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.PackageVersion,
        createEntity: createPackageVersion,
    });
}
exports.createPackageVersionFixturesFactories = createPackageVersionFixturesFactories;
//# sourceMappingURL=packageVersionFixtures.js.map