"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPackageFixturesFactories = exports.createPackage = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createPackage({ organization, account, customFields }) {
    return Object.assign({ uid: faker_1.faker.datatype.uuid(), packageName: faker_1.faker.unique(faker_1.faker.random.word), createdAt: faker_1.faker.datatype.datetime(), label: faker_1.faker.hacker.adjective(), description: faker_1.faker.hacker.phrase(), ownerOrganizationUid: organization.uid, createdByAccountId: account.id }, customFields);
}
exports.createPackage = createPackage;
function createPackageFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.Package,
        createEntity: createPackage,
    });
}
exports.createPackageFixturesFactories = createPackageFixturesFactories;
//# sourceMappingURL=packageFixtures.js.map