import { IOrganization } from '../../Schema/Organization/organizationModel';
import { IAccount } from '../../Schema/Account/accountModel';
import { IPackage } from '../../Schema/Package/packageModel';
export declare type CustomFields = Partial<Omit<IPackage, 'ownerOrganizationUid' | 'createdByAccountId'>>;
export interface CreateProps {
    organization: IOrganization;
    account: IAccount;
    customFields?: CustomFields;
}
export declare function createPackage({ organization, account, customFields }: CreateProps): IPackage;
export declare function createPackageFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IPackage, Partial<Omit<IPackage, "ownerOrganizationUid" | "createdByAccountId">>, CreateProps & {
        customFields?: Partial<Omit<IPackage, "ownerOrganizationUid" | "createdByAccountId">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IPackage, Partial<Omit<IPackage, "ownerOrganizationUid" | "createdByAccountId">>, CreateProps & {
        customFields?: Partial<Omit<IPackage, "ownerOrganizationUid" | "createdByAccountId">> | undefined;
    }>;
};
//# sourceMappingURL=packageFixtures.d.ts.map