import { IOrganizationTag } from '../../Schema/Organization/Tag/organizationTagModel';
export interface CreateProps {
    tagObject: {
        name: IOrganizationTag['name'];
        organizationUid: IOrganizationTag['uid'];
    };
    customFields?: Omit<Partial<IOrganizationTag>, 'organizationUid'>;
}
export declare function createOrganizationTag({ tagObject, customFields }: CreateProps): IOrganizationTag;
export declare function createOrganizationTagFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IOrganizationTag, Omit<Partial<IOrganizationTag>, "organizationUid">, CreateProps & {
        customFields?: Omit<Partial<IOrganizationTag>, "organizationUid"> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IOrganizationTag, Omit<Partial<IOrganizationTag>, "organizationUid">, CreateProps & {
        customFields?: Omit<Partial<IOrganizationTag>, "organizationUid"> | undefined;
    }>;
};
//# sourceMappingURL=organizationTagFixtures.d.ts.map