"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCompanyFixturesFactories = exports.createCompany = exports.createOrganizationFixturesFactories = exports.createOrganization = void 0;
const faker_1 = require("@faker-js/faker");
const string_1 = require("@signageos/lib/dist/String/string");
const Billing_1 = require("@signageos/common-types/dist/Billing/Billing");
const uid_1 = require("@signageos/common-types/dist/Entity/uid");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const subscriptionType_1 = require("./subscriptionType");
function createBase({ accounts }) {
    var _a;
    return {
        uid: (0, uid_1.generateUid)(),
        name: (0, string_1.getDomainName)(),
        title: faker_1.faker.hacker.adjective(),
        createdAt: faker_1.faker.datatype.datetime(),
        oauthClientId: faker_1.faker.random.alpha(10),
        oauthClientSecret: faker_1.faker.random.alphaNumeric(15),
        accountIds: (_a = accounts === null || accounts === void 0 ? void 0 : accounts.map((account) => account.id)) !== null && _a !== void 0 ? _a : [],
        isSuper: false,
    };
}
function createOrganization({ accounts, customFields, parentCompany }) {
    return Object.assign(Object.assign(Object.assign({}, createBase({ accounts })), { parentUid: parentCompany.uid, isCompany: false, subscriptionType: (0, subscriptionType_1.getRandomSubscriptionType)() }), customFields);
}
exports.createOrganization = createOrganization;
function createOrganizationFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.Organization,
        createEntity: createOrganization,
    });
}
exports.createOrganizationFixturesFactories = createOrganizationFixturesFactories;
function createCompany({ accounts, companyNetworks, whiteLabelSettings, customFields }) {
    var _a;
    return Object.assign(Object.assign(Object.assign({}, createBase({ accounts })), { isCompany: true, companyNetworkUids: (_a = companyNetworks === null || companyNetworks === void 0 ? void 0 : companyNetworks.map((companyNetwork) => companyNetwork.uid)) !== null && _a !== void 0 ? _a : [], whiteLabelSettingsUid: whiteLabelSettings === null || whiteLabelSettings === void 0 ? void 0 : whiteLabelSettings.uid, billingPlan: Billing_1.BillingPlan.Open }), customFields);
}
exports.createCompany = createCompany;
function createCompanyFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.Organization,
        createEntity: createCompany,
    });
}
exports.createCompanyFixturesFactories = createCompanyFixturesFactories;
//# sourceMappingURL=organizationFixtures.js.map