import { IAccount } from '../../Schema/Account/accountModel';
import { ICompanyNetwork } from '../../Schema/CompanyNetwork/companyNetworkModel';
import { IOrganization } from '../../Schema/Organization/organizationModel';
import { IWhiteLabelSettings } from '../../Schema/WhiteLabelSettings/whiteLabelSettingsModel';
export declare type Organization = IOrganization & {
    isCompany: false;
};
export declare type BaseOmitFields = 'parentUid' | 'accountIds' | 'companyNetworkUids' | 'whiteLabelSettingsUid' | 'isCompany';
export declare type OrganizationOmitFields = BaseOmitFields | 'billingPlan' | 'billingInfo' | 'deviceNameTemplate' | 'emailDomains' | 'defaultAccountRole';
export declare type OrganizationCustomFields = Partial<Omit<IOrganization, OrganizationOmitFields>>;
export interface IBaseCreateProps {
    accounts?: IAccount[];
}
export interface CreateOrganizationProps extends IBaseCreateProps {
    parentCompany: Company;
    customFields?: OrganizationCustomFields;
}
export declare function createOrganization({ accounts, customFields, parentCompany }: CreateOrganizationProps): Organization;
export declare function createOrganizationFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<Organization, Partial<Omit<IOrganization, OrganizationOmitFields>>, CreateOrganizationProps & {
        customFields?: Partial<Omit<IOrganization, OrganizationOmitFields>> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<Organization, Partial<Omit<IOrganization, OrganizationOmitFields>>, CreateOrganizationProps & {
        customFields?: Partial<Omit<IOrganization, OrganizationOmitFields>> | undefined;
    }>;
};
export declare type Company = IOrganization & {
    isCompany: true;
};
export declare type CompanyOmitFields = BaseOmitFields | 'subscriptionType' | 'defaultSubscriptionType';
export declare type CompanyCustomFields = Partial<Omit<IOrganization, CompanyOmitFields>>;
export interface CreateCompanyProps extends IBaseCreateProps {
    companyNetworks?: ICompanyNetwork[];
    whiteLabelSettings?: IWhiteLabelSettings;
    customFields?: CompanyCustomFields;
}
export declare function createCompany({ accounts, companyNetworks, whiteLabelSettings, customFields }: CreateCompanyProps): Company;
export declare function createCompanyFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<Company, Partial<Omit<IOrganization, CompanyOmitFields>>, CreateCompanyProps & {
        customFields?: Partial<Omit<IOrganization, CompanyOmitFields>> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<Company, Partial<Omit<IOrganization, CompanyOmitFields>>, CreateCompanyProps & {
        customFields?: Partial<Omit<IOrganization, CompanyOmitFields>> | undefined;
    }>;
};
//# sourceMappingURL=organizationFixtures.d.ts.map