import { ILocation } from '../../Schema/Location/locationModel';
import { IOrganization } from '../../Schema/Organization/organizationModel';
import { Feature, Point, GeoJsonProperties } from 'geojson';
export declare type CustomFields = Partial<ILocation>;
export interface CreateProps {
    customFields?: CustomFields;
    organization: IOrganization;
}
export declare function createLocation({ organization, customFields }: CreateProps): ILocation;
export declare function createLocationFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<ILocation, Partial<ILocation>, CreateProps & {
        customFields?: Partial<ILocation> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<ILocation, Partial<ILocation>, CreateProps & {
        customFields?: Partial<ILocation> | undefined;
    }>;
};
export declare function createFeatureFixture({ state, country }: {
    state?: string;
    country?: string;
}): Feature<Point, GeoJsonProperties>;
//# sourceMappingURL=locationFixtures.d.ts.map