"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createIssuedServerLicenseValidityFixturesFactories = exports.createIssuedServerLicenseValidity = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createIssuedServerLicenseValidity({ issuedServerLicense, customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), issuedServerLicenseId: issuedServerLicense.id, createdAt: faker_1.faker.date.past(), expireAt: faker_1.faker.date.future(), license: faker_1.faker.datatype.string(), signature: faker_1.faker.datatype.string() }, customFields);
}
exports.createIssuedServerLicenseValidity = createIssuedServerLicenseValidity;
function createIssuedServerLicenseValidityFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.IssuedServerLicenseValidity,
        createEntity: createIssuedServerLicenseValidity,
    });
}
exports.createIssuedServerLicenseValidityFixturesFactories = createIssuedServerLicenseValidityFixturesFactories;
//# sourceMappingURL=issuedServerLicenseValidityFixtures.js.map