"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createIssuedServerLicenseFixturesFactories = exports.createIssuedServerLicense = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createIssuedServerLicense({ organization, customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), organizationUid: organization.uid, licenseKey: faker_1.faker.datatype.string(), licenseSecret: faker_1.faker.datatype.string(), createdAt: faker_1.faker.date.past() }, customFields);
}
exports.createIssuedServerLicense = createIssuedServerLicense;
function createIssuedServerLicenseFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.IssuedServerLicense,
        createEntity: createIssuedServerLicense,
    });
}
exports.createIssuedServerLicenseFixturesFactories = createIssuedServerLicenseFixturesFactories;
//# sourceMappingURL=issuedServerLicenseFixtures.js.map