import { IIssuedServerLicense } from '../../Schema/License/issuedServerLicenseModel';
import { IOrganization } from '../../Schema/Organization/organizationModel';
export declare type CustomFields = Partial<Omit<IIssuedServerLicense, 'organizationUid'>>;
export interface CreateProps {
    organization: IOrganization;
    customFields?: CustomFields;
}
export declare function createIssuedServerLicense({ organization, customFields }: CreateProps): IIssuedServerLicense;
export declare function createIssuedServerLicenseFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IIssuedServerLicense, Partial<Omit<IIssuedServerLicense, "organizationUid">>, CreateProps & {
        customFields?: Partial<Omit<IIssuedServerLicense, "organizationUid">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IIssuedServerLicense, Partial<Omit<IIssuedServerLicense, "organizationUid">>, CreateProps & {
        customFields?: Partial<Omit<IIssuedServerLicense, "organizationUid">> | undefined;
    }>;
};
//# sourceMappingURL=issuedServerLicenseFixtures.d.ts.map