"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceVerificationFixturesFactories = exports.createDeviceVerification = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
function createDeviceVerification({ device, customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), createdAt: faker_1.faker.date.past(), deviceIdentityHash: device.identityHash, hash: faker_1.faker.datatype.string(6), verifiedAt: null, verifierId: null }, customFields);
}
exports.createDeviceVerification = createDeviceVerification;
function createDeviceVerificationFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.DeviceCollection.Verification,
        createEntity: createDeviceVerification,
    });
}
exports.createDeviceVerificationFixturesFactories = createDeviceVerificationFixturesFactories;
//# sourceMappingURL=deviceVerificationFixtures.js.map