"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceSessionFixturesFactories = exports.createDeviceSession = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
function createDeviceSession({ customFields }) {
    return Object.assign({ deviceIdentityHash: faker_1.faker.datatype.uuid(), sessionUid: faker_1.faker.datatype.uuid(), createdAt: faker_1.faker.datatype.datetime() }, customFields);
}
exports.createDeviceSession = createDeviceSession;
function createDeviceSessionFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.DeviceCollection.Session,
        createEntity: createDeviceSession,
    });
}
exports.createDeviceSessionFixturesFactories = createDeviceSessionFixturesFactories;
//# sourceMappingURL=deviceSessionFixtures.js.map