import { IDevice } from '../../../Schema/Device/deviceModel';
import { IDeviceScreenshot } from '../../../Schema/Device/Screenshot/deviceScreenshotModel';
export declare type CustomFields = Partial<Omit<IDeviceScreenshot, 'deviceIdentityHash'>>;
export interface CreateProps {
    device: IDevice;
    customFields?: CustomFields;
}
export declare function createScreenshot({ device, customFields }: CreateProps): IDeviceScreenshot;
export declare function createScreenshotFixturesFactories(): {
    createSimpleFactory(): import("../../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IDeviceScreenshot, Partial<Omit<IDeviceScreenshot, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDeviceScreenshot, "deviceIdentityHash">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IDeviceScreenshot, Partial<Omit<IDeviceScreenshot, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDeviceScreenshot, "deviceIdentityHash">> | undefined;
    }>;
};
//# sourceMappingURL=screenshotFixtures.d.ts.map