import { IDeviceInfo } from '../../../Schema/Device/Info/deviceInfoModel';
import { IDevice } from '../../../Schema/Device/deviceModel';
export declare type CustomFields = Partial<Omit<IDeviceInfo, 'identityHash'>>;
export interface CreateProps {
    device: IDevice;
    customFields?: CustomFields;
}
export declare function createDeviceInfo({ device, customFields }: CreateProps): IDeviceInfo & {
    minStorageStatusFreeSpacePercentage: number;
};
export declare function createDeviceInfoFixturesFactories(): {
    createSimpleFactory(): import("../../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IDeviceInfo & {
        minStorageStatusFreeSpacePercentage: number;
    }, Partial<Omit<IDeviceInfo, "identityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDeviceInfo, "identityHash">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IDeviceInfo & {
        minStorageStatusFreeSpacePercentage: number;
    }, Partial<Omit<IDeviceInfo, "identityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDeviceInfo, "identityHash">> | undefined;
    }>;
};
//# sourceMappingURL=deviceInfoFixtures.d.ts.map