"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceConfigurationFixturesFactories = exports.createDeviceConfiguration = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
function createDeviceConfiguration({ device, customFields }) {
    return Object.assign({ deviceIdentityHash: device.identityHash, createdAt: faker_1.faker.datatype.datetime(), updatedAt: faker_1.faker.datatype.datetime(), bannedSince: null, subscriptionType: null, platformUri: null, staticBaseUrl: null, uploadBaseUrl: null, weinreUri: null, extendedManagementUrl: null, socketDriver: null }, customFields);
}
exports.createDeviceConfiguration = createDeviceConfiguration;
function createDeviceConfigurationFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.DeviceCollection.Configuration,
        createEntity: createDeviceConfiguration,
    });
}
exports.createDeviceConfigurationFixturesFactories = createDeviceConfigurationFixturesFactories;
//# sourceMappingURL=deviceConfigurationFixtures.js.map