import { IDevice } from '../../../Schema/Device/deviceModel';
import { IDeviceConfiguration } from '../../../Schema/Device/Configuration/deviceConfigurationModel';
export declare type CustomFields = Partial<Omit<IDeviceConfiguration, 'deviceIdentityHash'>>;
export interface CreateProps {
    device: IDevice;
    customFields?: CustomFields;
}
export declare function createDeviceConfiguration({ device, customFields }: CreateProps): IDeviceConfiguration;
export declare function createDeviceConfigurationFixturesFactories(): {
    createSimpleFactory(): import("../../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IDeviceConfiguration, Partial<Omit<IDeviceConfiguration, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDeviceConfiguration, "deviceIdentityHash">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IDeviceConfiguration, Partial<Omit<IDeviceConfiguration, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDeviceConfiguration, "deviceIdentityHash">> | undefined;
    }>;
};
//# sourceMappingURL=deviceConfigurationFixtures.d.ts.map