"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceActionLogFixturesFactories = exports.createDeviceActionLog = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
const deviceActionLogModel_1 = require("../../../Schema/Device/ActionLog/deviceActionLogModel");
function createDeviceActionLog({ device, customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), uid: faker_1.faker.datatype.uuid(), requestId: faker_1.faker.datatype.uuid(), deviceIdentityHash: device.identityHash, type: deviceActionLogModel_1.DeviceActionType.SET_VOLUME, data: {}, createdAt: faker_1.faker.date.past(), succeedAt: faker_1.faker.date.past(), failedAt: null, updatedAt: null }, customFields);
}
exports.createDeviceActionLog = createDeviceActionLog;
function createDeviceActionLogFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.DeviceCollection.ActionLog,
        createEntity: createDeviceActionLog,
    });
}
exports.createDeviceActionLogFixturesFactories = createDeviceActionLogFixturesFactories;
//# sourceMappingURL=deviceActionLogFixtures.js.map