import { IDevice } from '../../../Schema/Device/deviceModel';
import { DeviceActionType, IDeviceActionLog } from '../../../Schema/Device/ActionLog/deviceActionLogModel';
export declare type CustomFields = Partial<Omit<IDeviceActionLog<any>, 'deviceIdentityHash'>>;
export interface CreateProps {
    device: IDevice;
    customFields?: CustomFields;
}
export declare function createDeviceActionLog({ device, customFields }: CreateProps): IDeviceActionLog<DeviceActionType>;
export declare function createDeviceActionLogFixturesFactories(): {
    createSimpleFactory(): import("../../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IDeviceActionLog<DeviceActionType>, Partial<Omit<IDeviceActionLog<any>, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDeviceActionLog<any>, "deviceIdentityHash">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IDeviceActionLog<DeviceActionType>, Partial<Omit<IDeviceActionLog<any>, "deviceIdentityHash">>, CreateProps & {
        customFields?: Partial<Omit<IDeviceActionLog<any>, "deviceIdentityHash">> | undefined;
    }>;
};
//# sourceMappingURL=deviceActionLogFixtures.d.ts.map