"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCompanyNetworkFixturesFactories = exports.createCompanyNetwork = void 0;
const faker_1 = require("@faker-js/faker");
const uid_1 = require("@signageos/common-types/dist/Entity/uid");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const subscriptionType_1 = require("../Organization/subscriptionType");
function createCompanyNetwork({ whiteLabelSettings, legacyWhiteLabelSettings, customFields }) {
    const createdAt = faker_1.faker.date.past();
    return Object.assign(Object.assign({ uid: (0, uid_1.generateUid)(), name: faker_1.faker.datatype.string(), subscriptionType: (0, subscriptionType_1.getRandomSubscriptionType)(), createdAt, updatedAt: faker_1.faker.date.between(createdAt, new Date()), whiteLabelSettingsUids: whiteLabelSettings ? whiteLabelSettings.map((wls) => wls.uid) : [] }, (legacyWhiteLabelSettings ? { whiteLabelSettingsUid: legacyWhiteLabelSettings.uid } : {})), customFields);
}
exports.createCompanyNetwork = createCompanyNetwork;
function createCompanyNetworkFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.CompanyNetwork,
        createEntity: createCompanyNetwork,
    });
}
exports.createCompanyNetworkFixturesFactories = createCompanyNetworkFixturesFactories;
//# sourceMappingURL=companyNetworkFixtures.js.map