import { IBulkRequestedEvent } from '../../Schema/BulkOperation/bulkRequestedEventModel';
import { IDevice } from '../../Schema/Device/deviceModel';
import { IBulkOperationAlias } from '../../Schema/BulkOperation/bulkOperationModel';
export declare type CustomFields = Partial<Omit<IBulkRequestedEvent, 'sourceUid' | 'deviceIdentityHash'>>;
export declare function createBulkRequestedEventFixtureFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<{
        createdAt: Date;
        requestUid: string;
        sourceUid: string;
        deviceIdentityHash: string;
    }, Partial<Omit<IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">>, {
        device: IDevice;
        bulkOperation: IBulkOperationAlias;
        customFields?: Partial<Omit<IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">> | undefined;
    } & {
        customFields?: Partial<Omit<IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<{
        createdAt: Date;
        requestUid: string;
        sourceUid: string;
        deviceIdentityHash: string;
    }, Partial<Omit<IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">>, {
        device: IDevice;
        bulkOperation: IBulkOperationAlias;
        customFields?: Partial<Omit<IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">> | undefined;
    } & {
        customFields?: Partial<Omit<IBulkRequestedEvent, "sourceUid" | "deviceIdentityHash">> | undefined;
    }>;
};
//# sourceMappingURL=bulkRequestedEventFixtures.d.ts.map