"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBulkOperationFixturesFactories = exports.createBulkOperation = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const originator_1 = require("../Originator/originator");
const Enums_1 = require("@signageos/common-types/dist/BulkOperation/Enums");
function createBulkOperation({ originator, organizations, failedDevices, inProgressDevices, successfulDevices, skippedDevices, customFields, }) {
    var _a, _b, _c, _d;
    const allDevices = [...(failedDevices !== null && failedDevices !== void 0 ? failedDevices : []), ...(inProgressDevices !== null && inProgressDevices !== void 0 ? inProgressDevices : []), ...(successfulDevices !== null && successfulDevices !== void 0 ? successfulDevices : []), ...(skippedDevices !== null && skippedDevices !== void 0 ? skippedDevices : [])];
    return Object.assign({ uid: faker_1.faker.datatype.uuid(), name: faker_1.faker.hacker.adjective(), filter: {}, deviceUids: allDevices.map((device) => ({
            uid: device.uid,
            identityHash: device.identityHash,
        })), failedDeviceUids: (failedDevices !== null && failedDevices !== void 0 ? failedDevices : []).map((device) => device.uid), successfulDeviceUids: (successfulDevices !== null && successfulDevices !== void 0 ? successfulDevices : []).map((device) => device.uid), skippedDeviceUids: (skippedDevices !== null && skippedDevices !== void 0 ? skippedDevices : []).map((device) => device.uid), inProgressDeviceUids: (inProgressDevices !== null && inProgressDevices !== void 0 ? inProgressDevices : []).map((device) => device.uid), createdAt: faker_1.faker.datatype.datetime(), currentStatus: Enums_1.BulkOperationStatus.ARCHIVED, isRunning: false, operationType: faker_1.faker.hacker.noun(), data: {}, progress: {
            total: allDevices.length,
            failed: (_a = failedDevices === null || failedDevices === void 0 ? void 0 : failedDevices.length) !== null && _a !== void 0 ? _a : 0,
            inProgress: (_b = inProgressDevices === null || inProgressDevices === void 0 ? void 0 : inProgressDevices.length) !== null && _b !== void 0 ? _b : 0,
            succeeded: (_c = successfulDevices === null || successfulDevices === void 0 ? void 0 : successfulDevices.length) !== null && _c !== void 0 ? _c : 0,
            skipped: (_d = skippedDevices === null || skippedDevices === void 0 ? void 0 : skippedDevices.length) !== null && _d !== void 0 ? _d : 0,
        }, originator: (0, originator_1.originatorToDB)(originator), organizationUids: organizations.map((organization) => organization.uid) }, customFields);
}
exports.createBulkOperation = createBulkOperation;
function createBulkOperationFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.BulkOperation,
        createEntity: createBulkOperation,
    });
}
exports.createBulkOperationFixturesFactories = createBulkOperationFixturesFactories;
//# sourceMappingURL=bulkOperationFixtures.js.map