import { IDevice } from '../../Schema/Device/deviceModel';
import { IBulkOperation } from '../../Schema/BulkOperation/bulkOperationModel';
import { IOrganization } from '../../Schema/Organization/organizationModel';
import { Originator } from '../Originator/originator';
import { LogData } from '@signageos/common-types/dist/BulkOperation/Types';
import { DeviceActionType } from '@signageos/common-types/dist/BulkOperation/Enums';
export declare type CustomFields = Partial<Omit<IBulkOperation<LogData[DeviceActionType], DeviceActionType>, 'deviceUids' | 'failedDeviceUids' | 'successfulDeviceUids' | 'skippedDeviceUids' | 'originator' | 'organizationUids'>>;
export interface CreateProps {
    originator: Originator;
    organizations: IOrganization[];
    failedDevices?: IDevice[];
    inProgressDevices?: IDevice[];
    successfulDevices?: IDevice[];
    skippedDevices?: IDevice[];
    customFields?: CustomFields;
}
export declare function createBulkOperation({ originator, organizations, failedDevices, inProgressDevices, successfulDevices, skippedDevices, customFields, }: CreateProps): IBulkOperation<LogData[DeviceActionType], DeviceActionType>;
export declare function createBulkOperationFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IBulkOperation<{
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        version: string;
    } | {
        volume: number;
    } | {
        brightness1: number;
        brightness2: number;
        timeFrom1: string;
        timeFrom2: string;
    } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
        timestamp: number;
        timezone: string | null;
        ntpServer?: string | undefined;
    } | {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    } | {
        version: string;
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        buildHash: string;
        version: string;
        build: string | null;
    } | {
        packageUri: string;
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        specs: object;
    } | {
        powerType: string;
    } | {
        powerType: string;
        weekdays: string[];
        time: string;
    } | {
        scheduledPowerActionUid: string;
    } | {
        enabled: boolean;
    } | {
        resolution: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
        videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
    } | {
        verificationHash: string;
    } | {
        verificationHash: string;
    } | {
        name: string;
    } | {
        subscriptionType: string | null;
    } | {
        appletUid: string;
        appletVersion: string;
        startsAt: Date | undefined;
        endsAt: Date | undefined;
        configuration: Record<string, unknown>;
        finishEvent: {
            type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
            data?: any;
        } | undefined;
        position: number | undefined;
        active: boolean | undefined;
    } | {
        appletUid: string;
        appletVersion: string | undefined;
        startsAt: Date | undefined;
        endsAt: Date | undefined;
        configuration: Record<string, unknown> | undefined;
        configurationSet: Record<string, unknown> | undefined;
        configurationRemoveKeys: string[] | undefined;
        finishEvent: {
            type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
            data?: any;
        } | undefined;
        position: number | undefined;
        active: boolean | undefined;
    } | {
        uid: string;
        appletUid: string;
        appletVersion: string;
    } | {
        policyUid: string;
        priority: number;
    } | {
        policyUid: string;
    } | {
        deviceIdentityHash: string;
        tagUids: string[];
    } | {
        deviceIdentityHash: string;
        tagUids: string[];
    } | {
        organizationUid: string;
    } | {
        appletUid: string;
        appletVersion: string;
        tests: string[];
    } | {
        tests: string[];
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
    } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
        turnedOn: boolean;
    } | {
        inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
    } | {
        backlight: number;
    } | {
        contrast: number;
    } | {
        sharpness: number;
    } | {
        maxTemperature: number;
    } | {
        enabled: boolean;
        remoteDesktopUri?: string | undefined;
    } | {
        enabled: true;
        healthcheckIntervalMs: number;
    } | {
        enabled: false;
        autoEnableTimeoutMs?: number | undefined;
    } | {
        enabled: true;
    } | {
        enabled: false;
        autoEnableTimeoutMs?: number | undefined;
    } | {
        deviceIdentityHash: string;
        duration: number;
    } | {
        deviceIdentityHash: string;
    } | {
        deviceIdentityHash: string;
        telemetryCheckIntervals: {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            default?: number | undefined;
        };
    }, DeviceActionType>, Partial<Omit<IBulkOperation<{
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        version: string;
    } | {
        volume: number;
    } | {
        brightness1: number;
        brightness2: number;
        timeFrom1: string;
        timeFrom2: string;
    } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
        timestamp: number;
        timezone: string | null;
        ntpServer?: string | undefined;
    } | {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    } | {
        version: string;
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        buildHash: string;
        version: string;
        build: string | null;
    } | {
        packageUri: string;
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        specs: object;
    } | {
        powerType: string;
    } | {
        powerType: string;
        weekdays: string[];
        time: string;
    } | {
        scheduledPowerActionUid: string;
    } | {
        enabled: boolean;
    } | {
        resolution: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
        videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
    } | {
        verificationHash: string;
    } | {
        verificationHash: string;
    } | {
        name: string;
    } | {
        subscriptionType: string | null;
    } | {
        appletUid: string;
        appletVersion: string;
        startsAt: Date | undefined;
        endsAt: Date | undefined;
        configuration: Record<string, unknown>;
        finishEvent: {
            type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
            data?: any;
        } | undefined;
        position: number | undefined;
        active: boolean | undefined;
    } | {
        appletUid: string;
        appletVersion: string | undefined;
        startsAt: Date | undefined;
        endsAt: Date | undefined;
        configuration: Record<string, unknown> | undefined;
        configurationSet: Record<string, unknown> | undefined;
        configurationRemoveKeys: string[] | undefined;
        finishEvent: {
            type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
            data?: any;
        } | undefined;
        position: number | undefined;
        active: boolean | undefined;
    } | {
        uid: string;
        appletUid: string;
        appletVersion: string;
    } | {
        policyUid: string;
        priority: number;
    } | {
        policyUid: string;
    } | {
        deviceIdentityHash: string;
        tagUids: string[];
    } | {
        deviceIdentityHash: string;
        tagUids: string[];
    } | {
        organizationUid: string;
    } | {
        appletUid: string;
        appletVersion: string;
        tests: string[];
    } | {
        tests: string[];
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
    } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
        turnedOn: boolean;
    } | {
        inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
    } | {
        backlight: number;
    } | {
        contrast: number;
    } | {
        sharpness: number;
    } | {
        maxTemperature: number;
    } | {
        enabled: boolean;
        remoteDesktopUri?: string | undefined;
    } | {
        enabled: true;
        healthcheckIntervalMs: number;
    } | {
        enabled: false;
        autoEnableTimeoutMs?: number | undefined;
    } | {
        enabled: true;
    } | {
        enabled: false;
        autoEnableTimeoutMs?: number | undefined;
    } | {
        deviceIdentityHash: string;
        duration: number;
    } | {
        deviceIdentityHash: string;
    } | {
        deviceIdentityHash: string;
        telemetryCheckIntervals: {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            default?: number | undefined;
        };
    }, DeviceActionType>, "originator" | "deviceUids" | "failedDeviceUids" | "successfulDeviceUids" | "skippedDeviceUids" | "organizationUids">>, CreateProps & {
        customFields?: Partial<Omit<IBulkOperation<{
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            version: string;
        } | {
            volume: number;
        } | {
            brightness1: number;
            brightness2: number;
            timeFrom1: string;
            timeFrom2: string;
        } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
            timestamp: number;
            timezone: string | null;
            ntpServer?: string | undefined;
        } | {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        } | {
            version: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            buildHash: string;
            version: string;
            build: string | null;
        } | {
            packageUri: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            specs: object;
        } | {
            powerType: string;
        } | {
            powerType: string;
            weekdays: string[];
            time: string;
        } | {
            scheduledPowerActionUid: string;
        } | {
            enabled: boolean;
        } | {
            resolution: {
                height: number;
                width: number;
                framerate?: number | undefined;
            };
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        } | {
            verificationHash: string;
        } | {
            verificationHash: string;
        } | {
            name: string;
        } | {
            subscriptionType: string | null;
        } | {
            appletUid: string;
            appletVersion: string;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown>;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            appletUid: string;
            appletVersion: string | undefined;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown> | undefined;
            configurationSet: Record<string, unknown> | undefined;
            configurationRemoveKeys: string[] | undefined;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            uid: string;
            appletUid: string;
            appletVersion: string;
        } | {
            policyUid: string;
            priority: number;
        } | {
            policyUid: string;
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            organizationUid: string;
        } | {
            appletUid: string;
            appletVersion: string;
            tests: string[];
        } | {
            tests: string[];
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
            turnedOn: boolean;
        } | {
            inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
        } | {
            backlight: number;
        } | {
            contrast: number;
        } | {
            sharpness: number;
        } | {
            maxTemperature: number;
        } | {
            enabled: boolean;
            remoteDesktopUri?: string | undefined;
        } | {
            enabled: true;
            healthcheckIntervalMs: number;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            enabled: true;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            deviceIdentityHash: string;
            duration: number;
        } | {
            deviceIdentityHash: string;
        } | {
            deviceIdentityHash: string;
            telemetryCheckIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }, DeviceActionType>, "originator" | "deviceUids" | "failedDeviceUids" | "successfulDeviceUids" | "skippedDeviceUids" | "organizationUids">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IBulkOperation<{
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        version: string;
    } | {
        volume: number;
    } | {
        brightness1: number;
        brightness2: number;
        timeFrom1: string;
        timeFrom2: string;
    } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
        timestamp: number;
        timezone: string | null;
        ntpServer?: string | undefined;
    } | {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    } | {
        version: string;
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        buildHash: string;
        version: string;
        build: string | null;
    } | {
        packageUri: string;
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        specs: object;
    } | {
        powerType: string;
    } | {
        powerType: string;
        weekdays: string[];
        time: string;
    } | {
        scheduledPowerActionUid: string;
    } | {
        enabled: boolean;
    } | {
        resolution: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
        videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
    } | {
        verificationHash: string;
    } | {
        verificationHash: string;
    } | {
        name: string;
    } | {
        subscriptionType: string | null;
    } | {
        appletUid: string;
        appletVersion: string;
        startsAt: Date | undefined;
        endsAt: Date | undefined;
        configuration: Record<string, unknown>;
        finishEvent: {
            type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
            data?: any;
        } | undefined;
        position: number | undefined;
        active: boolean | undefined;
    } | {
        appletUid: string;
        appletVersion: string | undefined;
        startsAt: Date | undefined;
        endsAt: Date | undefined;
        configuration: Record<string, unknown> | undefined;
        configurationSet: Record<string, unknown> | undefined;
        configurationRemoveKeys: string[] | undefined;
        finishEvent: {
            type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
            data?: any;
        } | undefined;
        position: number | undefined;
        active: boolean | undefined;
    } | {
        uid: string;
        appletUid: string;
        appletVersion: string;
    } | {
        policyUid: string;
        priority: number;
    } | {
        policyUid: string;
    } | {
        deviceIdentityHash: string;
        tagUids: string[];
    } | {
        deviceIdentityHash: string;
        tagUids: string[];
    } | {
        organizationUid: string;
    } | {
        appletUid: string;
        appletVersion: string;
        tests: string[];
    } | {
        tests: string[];
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
    } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
        turnedOn: boolean;
    } | {
        inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
    } | {
        backlight: number;
    } | {
        contrast: number;
    } | {
        sharpness: number;
    } | {
        maxTemperature: number;
    } | {
        enabled: boolean;
        remoteDesktopUri?: string | undefined;
    } | {
        enabled: true;
        healthcheckIntervalMs: number;
    } | {
        enabled: false;
        autoEnableTimeoutMs?: number | undefined;
    } | {
        enabled: true;
    } | {
        enabled: false;
        autoEnableTimeoutMs?: number | undefined;
    } | {
        deviceIdentityHash: string;
        duration: number;
    } | {
        deviceIdentityHash: string;
    } | {
        deviceIdentityHash: string;
        telemetryCheckIntervals: {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            default?: number | undefined;
        };
    }, DeviceActionType>, Partial<Omit<IBulkOperation<{
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        version: string;
    } | {
        volume: number;
    } | {
        brightness1: number;
        brightness2: number;
        timeFrom1: string;
        timeFrom2: string;
    } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
        timestamp: number;
        timezone: string | null;
        ntpServer?: string | undefined;
    } | {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    } | {
        version: string;
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        buildHash: string;
        version: string;
        build: string | null;
    } | {
        packageUri: string;
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        specs: object;
    } | {
        powerType: string;
    } | {
        powerType: string;
        weekdays: string[];
        time: string;
    } | {
        scheduledPowerActionUid: string;
    } | {
        enabled: boolean;
    } | {
        resolution: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
        videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
    } | {
        verificationHash: string;
    } | {
        verificationHash: string;
    } | {
        name: string;
    } | {
        subscriptionType: string | null;
    } | {
        appletUid: string;
        appletVersion: string;
        startsAt: Date | undefined;
        endsAt: Date | undefined;
        configuration: Record<string, unknown>;
        finishEvent: {
            type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
            data?: any;
        } | undefined;
        position: number | undefined;
        active: boolean | undefined;
    } | {
        appletUid: string;
        appletVersion: string | undefined;
        startsAt: Date | undefined;
        endsAt: Date | undefined;
        configuration: Record<string, unknown> | undefined;
        configurationSet: Record<string, unknown> | undefined;
        configurationRemoveKeys: string[] | undefined;
        finishEvent: {
            type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
            data?: any;
        } | undefined;
        position: number | undefined;
        active: boolean | undefined;
    } | {
        uid: string;
        appletUid: string;
        appletVersion: string;
    } | {
        policyUid: string;
        priority: number;
    } | {
        policyUid: string;
    } | {
        deviceIdentityHash: string;
        tagUids: string[];
    } | {
        deviceIdentityHash: string;
        tagUids: string[];
    } | {
        organizationUid: string;
    } | {
        appletUid: string;
        appletVersion: string;
        tests: string[];
    } | {
        tests: string[];
    } | {
        packageName: string;
        applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
    } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
        turnedOn: boolean;
    } | {
        inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
    } | {
        backlight: number;
    } | {
        contrast: number;
    } | {
        sharpness: number;
    } | {
        maxTemperature: number;
    } | {
        enabled: boolean;
        remoteDesktopUri?: string | undefined;
    } | {
        enabled: true;
        healthcheckIntervalMs: number;
    } | {
        enabled: false;
        autoEnableTimeoutMs?: number | undefined;
    } | {
        enabled: true;
    } | {
        enabled: false;
        autoEnableTimeoutMs?: number | undefined;
    } | {
        deviceIdentityHash: string;
        duration: number;
    } | {
        deviceIdentityHash: string;
    } | {
        deviceIdentityHash: string;
        telemetryCheckIntervals: {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            default?: number | undefined;
        };
    }, DeviceActionType>, "originator" | "deviceUids" | "failedDeviceUids" | "successfulDeviceUids" | "skippedDeviceUids" | "organizationUids">>, CreateProps & {
        customFields?: Partial<Omit<IBulkOperation<{
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            version: string;
        } | {
            volume: number;
        } | {
            brightness1: number;
            brightness2: number;
            timeFrom1: string;
            timeFrom2: string;
        } | Record<string, never> | import("@signageos/common-types/dist/BulkOperation/Types").IConfigValues | {
            timestamp: number;
            timezone: string | null;
            ntpServer?: string | undefined;
        } | {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        } | {
            version: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            buildHash: string;
            version: string;
            build: string | null;
        } | {
            packageUri: string;
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
            specs: object;
        } | {
            powerType: string;
        } | {
            powerType: string;
            weekdays: string[];
            time: string;
        } | {
            scheduledPowerActionUid: string;
        } | {
            enabled: boolean;
        } | {
            resolution: {
                height: number;
                width: number;
                framerate?: number | undefined;
            };
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        } | {
            verificationHash: string;
        } | {
            verificationHash: string;
        } | {
            name: string;
        } | {
            subscriptionType: string | null;
        } | {
            appletUid: string;
            appletVersion: string;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown>;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            appletUid: string;
            appletVersion: string | undefined;
            startsAt: Date | undefined;
            endsAt: Date | undefined;
            configuration: Record<string, unknown> | undefined;
            configurationSet: Record<string, unknown> | undefined;
            configurationRemoveKeys: string[] | undefined;
            finishEvent: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType | undefined;
                data?: any;
            } | undefined;
            position: number | undefined;
            active: boolean | undefined;
        } | {
            uid: string;
            appletUid: string;
            appletVersion: string;
        } | {
            policyUid: string;
            priority: number;
        } | {
            policyUid: string;
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            deviceIdentityHash: string;
            tagUids: string[];
        } | {
            organizationUid: string;
        } | {
            appletUid: string;
            appletVersion: string;
            tests: string[];
        } | {
            tests: string[];
        } | {
            packageName: string;
            applicationType: "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "default" | "chromeos";
        } | import("@signageos/common-types/dist/BulkOperation/Types").ITimer | {
            turnedOn: boolean;
        } | {
            inputSource: import("@signageos/common-types/dist/Device/Input/InputSource").InputSource;
        } | {
            backlight: number;
        } | {
            contrast: number;
        } | {
            sharpness: number;
        } | {
            maxTemperature: number;
        } | {
            enabled: boolean;
            remoteDesktopUri?: string | undefined;
        } | {
            enabled: true;
            healthcheckIntervalMs: number;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            enabled: true;
        } | {
            enabled: false;
            autoEnableTimeoutMs?: number | undefined;
        } | {
            deviceIdentityHash: string;
            duration: number;
        } | {
            deviceIdentityHash: string;
        } | {
            deviceIdentityHash: string;
            telemetryCheckIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }, DeviceActionType>, "originator" | "deviceUids" | "failedDeviceUids" | "successfulDeviceUids" | "skippedDeviceUids" | "organizationUids">> | undefined;
    }>;
};
//# sourceMappingURL=bulkOperationFixtures.d.ts.map